import React, {Component} from 'react';
import {View, Text, StyleSheet, TouchableOpacity, Linking} from 'react-native';
import {getFontXD, toPriceVnd} from '../../../Config/Functions';
import R from '../../../assets/R';

const Footer = () => {
  return (
    <View style={{flex: 1, paddingHorizontal: 10, marginTop: 10}}>
      <View style={{flexDirection: 'row', marginVertical: 5}}>
        <Text style={styles.txtTitle}>Bạn có thể mở tài khoản thử </Text>
        <TouchableOpacity
          onPress={() =>
            Linking.openURL('https://reactnative.dev/docs/linking')
          }>
          <Text style={styles.txtLink}>Tại đây.</Text>
        </TouchableOpacity>
      </View>
      <Text style={styles.txtTitle}>Tạm tính:360.000</Text>
      <View
        style={{
          justifyContent: 'center',
          alignItems: 'center',
          marginVertical: 10,
        }}>
        <View style={styles.btnSend}>
          <Text style={styles.txtSend}>Mở tài khoản</Text>
        </View>
      </View>
    </View>
  );
};

const styles = StyleSheet.create({
  txtSend: {
    fontSize: getFontXD(42),
    color: R.colors.white,
    fontWeight: 'bold',
  },
  btnSend: {
    width: 140,
    height: 40,
    backgroundColor: R.colors.main,
    borderRadius: 10,
    justifyContent: 'center',
    alignItems: 'center',
  },
  txtTitle: {
    fontSize: getFontXD(42),
    color: R.colors.black,
  },
  txtLink: {
    fontSize: getFontXD(42),
    color: R.colors.main,
    marginLeft: 10,
    borderBottomWidth: 1,
    borderBottomColor: R.colors.main,
  },
});

export default Footer;
