import React, {useState} from 'react';
import {View, Text, StyleSheet, ScrollView} from 'react-native';
import HeaderBack from '../../../components/Header/HeaderBack';
import CheckBox from '@react-native-community/checkbox';
import R from '../../../assets/R';
import {getFontXD, toPriceVnd} from '../../../Config/Functions';

const ContainerTop = (props) => {
  const [isSelected, setSelection] = useState(false);
  return (
    <View style={styles.wrap}>
      <View style={styles.item}>
        <View style={{flex: 1}}>
          <Text>Mở tài khoản giao dịch CQG</Text>
        </View>
        <View
          style={{
            width: 120,
            marginRight: 30,
            alignItems: 'flex-end',
          }}>
          <Text style={[styles.txtMoney, {color: '#18B918'}]}>Miễn phí</Text>
        </View>
        <CheckBox
          value={isSelected}
          onValueChange={setSelection}
          boxType={'square'}
        />
      </View>
      <View style={styles.item}>
        <View style={{flex: 1}}>
          <Text>Duy trì treader</Text>
        </View>
        <View
          style={{
            width: 120,
            marginRight: 30,
            alignItems: 'flex-end',
          }}>
          <Text style={styles.txtMoney}>{toPriceVnd(360000)}</Text>
        </View>
        <CheckBox
          value={isSelected}
          onValueChange={setSelection}
          boxType={'square'}
        />
      </View>
    </View>
  );
};

const styles = StyleSheet.create({
  container: {
    paddingHorizontal: 10,
    paddingTop: 10,
  },
  checkboxContainer: {
    flexDirection: 'row',
    marginBottom: 20,
  },
  checkbox: {
    alignSelf: 'flex-end',
  },
  txtNote: {
    fontStyle: 'italic',
  },
  wrap: {
    marginVertical: 10,
    backgroundColor: R.colors.white,
    paddingVertical: 10,
    paddingHorizontal: 10,
    borderRadius: 10,
    shadowColor: '#AFA9A9',
    shadowOffset: {
      width: 0,
      height: 1,
    },
    shadowOpacity: 0.25,
    shadowRadius: 1.84,
    elevation: 1,
  },
  item: {
    flexDirection: 'row',
    justifyContent: 'space-between',
    alignItems: 'center',
    marginVertical: 10,
  },
  txtMoney: {
    fontSize: getFontXD(42),
    color: '#FFB721',
  },
  txtTitle: {
    fontSize: getFontXD(42),
    color: R.colors.main,
    marginTop: 10,
    fontWeight: 'bold',
  },
  txtGroup: {
    fontSize: getFontXD(42),
    color: R.colors.main,

    fontStyle: 'italic',
  },
});

export default ContainerTop;
