import React from 'react';
import {View, Text, StyleSheet, Image, TouchableOpacity} from 'react-native';
import HeaderDrawer from '../../components/Header/HeaderDrawer';
import {WIDTHXD, HEIGHTXD} from '../../Config/Functions';
import R from '../../assets/R';
import {useNavigation} from '@react-navigation/native';
import {
  USERINFOR,
  PAYMENTS,
  ROSE,
  BONUSTEAM,
  MYGROUP,
  AccountVerification,
  PROFILE,
} from '../../routers/ScreenNames';

const AccountView = (props) => {
  const navigate = useNavigation();

  return (
    <View>
      <HeaderDrawer title={'Tài khoản'} />
      <View style={styles.container}>
        <TouchableOpacity
          onPress={() => navigate.navigate(PROFILE)}
          style={styles.containerItem}>
          <Image source={R.images.iconUser} style={styles.imgIcon} />
          <Text>Thông tin cá nhân</Text>
        </TouchableOpacity>
        <TouchableOpacity
          onPress={() => navigate.navigate(AccountVerification)}
          style={styles.containerItem}>
          <Image source={R.images.iconUserAccuracy} style={styles.imgIcon} />
          <Text>Xác thực tài khoản</Text>
        </TouchableOpacity>

        <TouchableOpacity
          onPress={() => navigate.navigate(PAYMENTS)}
          style={styles.containerItem}>
          <Image source={R.images.iconList} style={styles.imgIcon} />
          <Text>Các khoản thanh toán</Text>
        </TouchableOpacity>

        <TouchableOpacity
          onPress={() => navigate.navigate(ROSE)}
          style={styles.containerItem}>
          <Image source={R.images.iconRose} style={styles.imgIcon} />
          <Text>Hoa hồng</Text>
        </TouchableOpacity>

        <TouchableOpacity
          onPress={() => navigate.navigate(BONUSTEAM)}
          style={styles.containerItem}>
          <Image source={R.images.iconWallet} style={styles.imgIcon} />
          <Text>Tiền thưởng đội nhóm</Text>
        </TouchableOpacity>

        <TouchableOpacity
          onPress={() => navigate.navigate(MYGROUP)}
          style={styles.containerItem}>
          <Image source={R.images.moneyteam} style={styles.imgIcon} />
          <Text>Đối tác của tôi</Text>
        </TouchableOpacity>
      </View>
    </View>
  );
};

export default AccountView;

const styles = StyleSheet.create({
  container: {
    flexDirection: 'row',
    paddingHorizontal: 30,

    justifyContent: 'space-between',
    flexWrap: 'wrap',
  },
  containerItem: {
    width: WIDTHXD(450),
    height: HEIGHTXD(450),
    backgroundColor: 'white',
    marginTop: 20,
    borderRadius: 10,
    justifyContent: 'center',
    alignItems: 'center',
    shadowColor: '#000',
    shadowOffset: {
      width: 0,
      height: 1,
    },
    shadowOpacity: 0.25,
    shadowRadius: 2.84,
    elevation: 3,
  },
  imgIcon: {
    width: WIDTHXD(216),
    height: HEIGHTXD(216),
    marginBottom: 10,
    resizeMode: 'contain',
  },
});
