import React, {useEffect} from 'react';
import {View, Text, Linking} from 'react-native';
import {createBottomTabNavigator} from '@react-navigation/bottom-tabs';
import Icon from 'react-native-vector-icons/FontAwesome5';
import Ionicons from 'react-native-vector-icons/Ionicons';
import FontAwesome from 'react-native-vector-icons/FontAwesome';

import Home from '../Screens/Home/Home';
import {connect} from 'react-redux';
import R from '../assets/R';
import PlussModal from './PlussModal';
import {confirmAlert} from '../components/Aleart';
import Account from '../Screens/Account/Account';
import Exchange from '../Screens/Exchange/Exchange';
import NewFeed from '../Screens/NewFeed/NewFeed';
import Notification from '../Screens/Notification/Notification';
import Test from '../Screens/NewFeed/Test';
import {useNavigation} from '@react-navigation/native';
import Transaction from '../Screens/Transaction/Transaction';
import {AccountVerification, PACKETCQG} from '../routers/ScreenNames';
import I18n from '../helper/i18/i18n';
import {changeLanguage} from '../actions/language';
import KEY from '../assets/AsynStorage';
import AsyncStorage from '@react-native-community/async-storage';
import {DETAILNEW} from '../routers/ScreenNames';

const Tab = createBottomTabNavigator();

const PayScreenComponent = () => {
  return null;
};

const TabNavigator = (props) => {
  const navigate = useNavigation();
  useEffect(() => {
    setInitLanguage();
    checkDeepking();
    setTimeout(() => {
      showPopUp();
    }, 3000);
  }, []);

  const checkDeepking = () => {
    Linking.getInitialURL().then((url) => {
      if (url) deeplinkScreen(url);
    });
    Linking.addEventListener('url', (url) => {
      if (url) handleOpenURL(url);
    });
  };

  const handleOpenURL = (event) => {
    deeplinkScreen(event.url);
  };

  const deeplinkScreen = (url) => {
    const route = url.replace(/.*?:\/\//g, '');
    const id = route.match(/\/([^\/]+)\/?$/)[1];
    const root = route.split('/')[0];
    // const routeName = route.split('/')[1];
    if (root == 'screen') {
      navigate.navigate(DETAILNEW, {id});
    }
  };

  useEffect(() => {
    checkScreenInit();
  }, [props.screenInit]);

  const checkScreenInit = () => {
    if (props.screenInit.screen) {
      const {screen, id} = props.screenInit;
      navigate.navigate(screen, {id: id});
    }
  };

  const setInitLanguage = async () => {
    const laguage = await AsyncStorage.getItem(KEY.LANGUAGE);
    if (laguage) props.changeLanguage(laguage);
  };

  const showPopUp = () => {
    if (props.user.status == 1) {
      return confirmAlert(I18n.t('PopupVerifyAccount'), () => {
        navigate.navigate(AccountVerification);
      });
    } else if (props.user.status == 3 && !props.user.contract_code) {
      return confirmAlert(I18n.t('PopupOpenCQG'), () => {
        navigate.navigate(PACKETCQG);
      });
    }
  };
  return (
    <View style={{flex: 1}}>
      <Tab.Navigator
        initialRouteName="Screen1"
        tabBarOptions={{activeTintColor: R.colors.main}}>
        <Tab.Screen
          name="Screen1"
          component={Home}
          options={{
            tabBarLabel: 'Overview',
            tabBarIcon: ({color, size}) => (
              <Icon name="landmark" size={size} color={color} />
            ),
          }}
        />

        <Tab.Screen
          name="Screen2"
          component={Transaction}
          options={{
            tabBarLabel: I18n.t('Tradding'),
            tabBarIcon: ({color, size}) => (
              <FontAwesome name="line-chart" size={size} color={color} />
            ),
          }}
        />

        <Tab.Screen
          name="Pay"
          component={PayScreenComponent}
          options={{
            tabBarButton: () => <PlussModal />,
          }}
        />

        <Tab.Screen
          name="Screen3"
          component={Notification}
          options={{
            tabBarLabel: I18n.t('Notification'),
            tabBarIcon: ({color, size}) => (
              <Ionicons
                name="ios-notifications-outline"
                size={size}
                color={color}
              />
            ),
          }}
        />
        <Tab.Screen
          name="Screen4"
          component={NewFeed}
          options={{
            tabBarLabel: I18n.t('News'),
            tabBarIcon: ({color, size}) => (
              <Ionicons name="newspaper-outline" size={size} color={color} />
            ),
          }}
        />
      </Tab.Navigator>
    </View>
  );
};

const mapStateToProps = (state) => {
  return {
    user: state.userReducer,
    notifi: state.CountNotificationReducer,
    screenInit: state.ScreenInitReducer,
  };
};

export default connect(mapStateToProps, {changeLanguage})(TabNavigator);
