import React, {useEffect, useState} from 'react';
import {
    Alert,
    ScrollView, StyleSheet, Text,
    View,
} from 'react-native';
import {getFontXD, HEIGHTXD} from '../../../../../Config/Functions';
import R from '../../../../../assets/R';
import {hideLoading, showLoading} from '../../../../../actions/loadingAction';
import {getContractDescription} from '../../../../../apis/Functions/Transaction';
import I18n from '../../../../../helper/i18/i18n';
const QualityStandard = (props) => {
    const[qualityStandard, setQualityStandard] = useState('')
    useEffect(() => {
        async function fetchData() {
            showLoading()
            const res = await getContractDescription(props.route.params.id)
            if(res.status === 200 && res.data.code ===200) {
                setQualityStandard(res.data.data.quality_standard_desc)
            } else {
                Alert.alert(I18n.t('Notification'), res.data.message);
            }
            hideLoading()
        }
        fetchData();
    }, [props.route.params.id]);
    return (
        <ScrollView
            style={styles.container}
            showsVerticalScrollIndicator={false}>
            <View style={{marginBottom: HEIGHTXD(100),
                backgroundColor: R.colors.white,
                width: '100%',
                shadowColor: '#181F4D21',
                shadowOffset: {width: 1, height: 1},
                shadowOpacity: 1,
                shadowRadius: 2,
                elevation: 1,}}>
                <Text style={styles.content}>{qualityStandard}</Text>
            </View>
        </ScrollView>
    )

}
export default QualityStandard
const styles = StyleSheet.create({
    container: {
        flex: 1,
        backgroundColor: R.colors.colorBackground,
        paddingTop: HEIGHTXD(30),
    },
    content: {
        flex: 3.5,
        fontSize: getFontXD(36),
        color: R.colors.black,
        paddingVertical: HEIGHTXD(30),
        paddingHorizontal: HEIGHTXD(30)
    },
});
