import React, {useState, useEffect} from 'react';
import {getListNotification} from '../../../apis/Functions/users';
import EscrowView from './EscrowView';
import I18n from '../../../helper/i18/i18n';
import {getListCategoryProduct, getTransactionListByCategory} from '../../../apis/Functions/Transaction';
import {Alert, Platform} from 'react-native';
import PriceListView from '../PriceList/PriceListView';
const Escrow = (props) => {
  const [selected, setSelected] = useState('');
  const [page, setPage] = useState(1);
  const [data, setData] = useState([]);
  const [tottalPage, setTotalPage] = useState(1);
  const [isRefresh, setIsRefresh] = useState(false);
  const [filters, setFilters] = useState([]);
  const [filterId, setFilterId] = useState(-1);

  useEffect(() => {
    getCategoryData();
  }, []);
  useEffect(() => {
    setData([])
    getData();
  }, [filterId]);

  const getCategoryData = async () => {
    // setIsRefresh(true);
    const res = await getListCategoryProduct({
      keyword: '',
      platform: Platform.OS,
      page_size: 20,
      page_index: 1,
      type: 'PRODUCT',
    });
    if ((res.data.code = 200 && res.data.data)) {
      let data = [];
      data.push({id: -1, name: 'All'});
      setFilters(data.concat([...res.data.data]));
    } else {
      Alert.alert(I18n.t('Notification'), res.data.message);
    }
  };

  const onRefresh = () => {
    setPage(1);
    getData();
  };

  const getData = async () => {
    setIsRefresh(true);
    setPage(1);
    const res = await getTransactionListByCategory({
      keyword: '',
      platform: Platform.OS,
      page_size: 10,
      page_index: 1,
      type:'ESCROW',
      category_id: filterId,
    });
    setIsRefresh(false);
    console.log('getData', res);
    if ((res.data.code = 200 && res.data.data)) {
      setData(res.data.data);
      setTotalPage(res.data.meta.pages);
    } else {
      Alert.alert(I18n.t('Notification'), res.data.message);
    }
  };

  const onLoadMore = () => {
    console.log(tottalPage);
    if (page < tottalPage) {
      getDataLoadMore();
    }
  };

  const getDataLoadMore = async () => {
    setIsRefresh(true);
    const res = await getTransactionListByCategory({
      keyword: '',
      platform: Platform.OS,
      page_size: 10,
      page_index: page + 1,
      type:'ESCROW',
      category_id: filterId,
    });
    setPage(page + 1);
    if (res.data.code == 200) {
      setData(data.concat(res.data.data));
    }
    setIsRefresh(false);
  };

  return (
    <EscrowView
      onRefresh={onRefresh}
      isRefresh={isRefresh}
      onLoadMore={onLoadMore}
      setFilterId={setFilterId}
      filterId={filterId}
      filters={filters}
      data={data}
    />
  );
};

export default Escrow;
