import React, {useEffect, useState} from 'react';
import {View, Alert} from 'react-native';
import {connect} from 'react-redux';
import {getTransaction} from '../../apis/Functions/users';
import {getImagesHome} from '../../apis/Functions/General';
import I18n from '../../helper/i18/i18n';

import HomeView from './HomeView';
import {useNavigation} from '@react-navigation/native';
import {AccountVerification, PACKETCQG} from '../../routers/ScreenNames';

const Home = (props) => {
  const [data, setData] = useState({total_deposit: 0, total_withdraw: 0});
  const [listImage, setListImage] = useState([]);
  useEffect(() => {
    getData();
  }, []);
  const getData = async () => {
    const res = await getTransaction({});
    if (res.data.code == 200 && res.data.data) {
      setData(res.data.data);
    } else {
      Alert.alert(I18n.t('Notification'), I18n.t('Can_not_get_data'));
    }

    const res1 = await getImagesHome({});
    if (res1.data.code == 200 && res1.data.data) {
      setListImage(res1.data.data);
    } else {
      Alert.alert(I18n.t('Notification'), I18n.t('Can_not_get_data'));
    }
  };

  return <HomeView data={data} listImage={listImage} />;
};

const mapStateToProps = (state) => {
  return {
    user: state.userReducer,
  };
};
export default connect(mapStateToProps, {})(Home);
