import React, {useState} from 'react';
import {View, Text, StyleSheet, FlatList, TouchableOpacity} from 'react-native';

import HeaderSearch from '../../components/Header/HeaderSearch';
import {getFontXD} from '../../Config/Functions';
import Item from './Item';
import AppText from '../../components/AppText';
import I18n from '../../helper/i18/i18n';

const Fillters = [
  {
    id: '1',
    name: 'All',
    value: 'all',
  },
  {
    id: '2',
    name: 'Deposit',
    value: 'deposit',
  },
  {
    id: '3',
    name: 'Withdraw',
    value: 'withdraw',
  },
  {
    id: '4',
    name: 'Withdraw',
    value: 'exchange',
  },
];

const data = [
  {
    id: '1',
    month: 2,
    day: '20',
    name: I18n.t('Deposit'),
    money: 10000000,
    note: '',
    status: 1,
    date: '20/02/2021',
  },
  {
    id: '2',
    month: 2,
    day: '20',
    name: I18n.t('Deposit'),
    money: 2000000,
    note: '',
    status: 1,
    date: '20/02/2021',
  },
  {
    id: '3',
    month: 2,
    day: '20',
    name: I18n.t('Deposit'),
    money: 3000000,
    note: '',
    status: 1,
    date: '20/02/2021',
  },
  {
    id: '4',
    month: 2,
    day: '20',
    name: I18n.t('Deposit'),
    money: 4000000,
    note: '',
    status: 1,
    date: '20/02/2021',
  },
  {
    id: '5',
    month: 2,
    day: '20',
    name: I18n.t('Deposit'),
    money: 9000000,
    note: '',
    status: 1,
    date: '20/02/2021',
  },
];
const ExchangeView = (props) => {
  const [selected, setSelected] = useState('1');

  return (
    <View style={{flex: 1}}>
      <HeaderSearch isWhite={true} title={I18n.t('Tradding')} />
      <View style={styles.headerContainer}>
        <FlatList
          showsHorizontalScrollIndicator={false}
          horizontal
          data={Fillters}
          keyExtractor={(item) => item.id}
          renderItem={({item}) => (
            <TouchableOpacity
              onPress={() => setSelected(item.id)}
              style={[
                styles.itemFillter,
                selected == item.id ? {borderColor: '#1473E6'} : null,
              ]}>
              <AppText
                i18nKey={e.name}
                style={[
                  styles.txtFillter,
                  selected == item.id ? {color: '#1473E6'} : {},
                ]}>
                {item.name}
              </AppText>
            </TouchableOpacity>
          )}
        />
      </View>
      <View style={{flex: 1}}>
        <FlatList
          keyExtractor={(item) => item.id}
          data={data}
          renderItem={({item}) => <Item item={item} />}
        />
      </View>
    </View>
  );
};

const styles = StyleSheet.create({
  headerContainer: {
    paddingVertical: 10,
    backgroundColor: 'white',
  },
  itemFillter: {
    borderRadius: 10,
    paddingVertical: 5,
    paddingHorizontal: 10,
    borderWidth: 1,
    borderColor: '#929292',
    marginLeft: 15,
    minWidth: 70,
  },
  txtFillter: {
    fontSize: getFontXD(36),
    color: '#929292',
  },
});

export default ExchangeView;
