import React, {Component} from 'react';
import {
  View,
  Text,
  StyleSheet,
  ImageBackground,
  TouchableOpacity,
} from 'react-native';
import R from '../../../assets/R';
import LinearGradient from 'react-native-linear-gradient';
import {getFontXD} from '../../../Config/Functions';
import Block from '../../../components/Block';
import Icon from 'react-native-vector-icons/AntDesign';
import {useNavigation} from '@react-navigation/native';
import {MEDIADETAIL} from '../../../routers/ScreenNames';

const MediaView = (props) => {
  //   const {poster,title} = props.mediaHot;
  //   console.log(mediaHot);
  const navigate = useNavigation();
  if (props.mediaHot) {
    const {poster, title, published_at, id, video_id} = props.mediaHot;

    return (
      <ImageBackground
        resizeMode={'cover'}
        style={styles.containerTop}
        source={{uri: poster}}>
        <LinearGradient
          start={{x: 0, y: 0}}
          end={{x: 0, y: 1}}
          colors={[
            'rgba(0, 0, 0, 0)',
            'rgba(0, 0, 0, 0.0)',
            'rgba(0, 0, 0, 0.7)',
          ]}
          style={{flex: 1}}>
          <View style={{flex: 2}} />
          <View style={styles.contentTop}>
            <TouchableOpacity
              onPress={() =>
                navigate.navigate(MEDIADETAIL, {id, video_id, title})
              }>
              <Text numberOfLines={2} style={styles.txtBig}>
                {title}
              </Text>
            </TouchableOpacity>

            <Block row space={'between'} padding={[10, 10]}>
              <View style={{flexDirection: 'row'}}>
                <Icon
                  name={'calendar'}
                  color={R.colors.white}
                  size={getFontXD(46)}
                />
                <Text style={styles.txtDate}>{published_at}</Text>
              </View>
              <TouchableOpacity
                onPress={() =>
                  navigate.navigate(MEDIADETAIL, {id, video_id, title})
                }
                style={styles.containerBtn}>
                <Icon
                  name={'playcircleo'}
                  color={R.colors.white}
                  size={getFontXD(46)}
                />
                <Text style={styles.txtPlay}>Xem video</Text>
              </TouchableOpacity>
            </Block>
          </View>
        </LinearGradient>
      </ImageBackground>
    );
  }

  return (
    <View>
      <Text>H</Text>
    </View>
  );
};

const styles = StyleSheet.create({
  containerTop: {
    height: 300,
    width: '100%',
  },
  contentTop: {
    padding: 10,
    flex: 1,
  },
  txtBig: {
    fontSize: getFontXD(52),
    color: R.colors.white,
    fontWeight: 'bold',
    textDecorationLine: 'underline',
  },
  containerBtn: {
    paddingHorizontal: 15,
    paddingVertical: 5,
    backgroundColor: '#1C6AF6',
    borderRadius: 5,
    justifyContent: 'center',
    alignItems: 'center',
    flexDirection: 'row',
    shadowColor: '#000',
    shadowOffset: {
      width: 0,
      height: 2,
    },
    shadowOpacity: 0.25,
    shadowRadius: 1.84,
    elevation: 2,
  },
  txtPlay: {
    color: R.colors.white,
    fontSize: getFontXD(42),
    fontWeight: 'bold',
    marginLeft: 5,
  },
  txtDate: {
    color: R.colors.white,
    fontSize: getFontXD(42),
    marginLeft: 5,
  },
});

export default MediaView;
