import React, {useState} from 'react';
import {View, Text, StyleSheet} from 'react-native';
import HeaderBack from '../../components/Header/HeaderBack';

import {WebView} from 'react-native-webview';
import {root} from '../../apis/url';

const DepositView = (props) => {
  console.log(props.route);
  return (
    <View style={{flex: 1}}>
      <HeaderBack isWhite={true} title={'Detail'} />
      <WebView
        androidHardwareAccelerationDisabled={true}
        domStorageEnabled={false}
        source={{
          uri:
            root + 'api/v1/posts/detail/web-view?id=' + props.route.params.id,
        }}
      />
    </View>
  );
};

const styles = StyleSheet.create({
  containerBtn: {
    marginBottom: 15,
  },
});

export default DepositView;
