import React, {useState} from 'react';
import {View, Text, FlatList, TouchableOpacity} from 'react-native';
import HeaderSB from '../../../components/Header/HeaderSB';
import Item from './Item';
import TextMoney from '../../../components/Input/InputMoney';
import {toPriceVnd, numberFormat} from '../../../Config/Functions';
import {changeLanguage} from '../../../actions/language';
import {connect} from 'react-redux';
import AppText from '../../../components/AppText';

const Rose = (props) => {
  const [text, setText] = useState('');
  return (
    <View style={{flex: 1}}>
      <HeaderSB title={'Rose'} />
      <View style={{justifyContent: 'center', alignItems: 'center', flex: 1}}>
        <AppText
          i18nKey={'Features_develop'}
          style={{
            fontSize: 18,
            fontWeight: 'bold',
            textAlign: 'center',
          }}
        />
      </View>
      {/* <View style={{flex: 1}}>
        <FlatList
          keyExtractor={(item) => item.id}
          data={data}
          renderItem={({item}) => <Item item={item} />}
        />
      </View> */}
    </View>
  );
};

const mapStateToProps = (state) => {
  return {
    loadingModal: state.ModalLoadingReducer,
  };
};

export default connect(mapStateToProps, {changeLanguage})(Rose);
