import React from 'react';
import {View, Text, StyleSheet, TouchableOpacity, Image} from 'react-native';
import {
  getFontXD,
  HEIGHTXD,
  WIDTHXD,
  toPriceVnd,
} from '../../../Config/Functions';
import R from '../../../assets/R';
import Block from '../../../components/Block';
import Icon from 'react-native-vector-icons/MaterialCommunityIcons';
import {DEPOSIT} from '../../../routers/ScreenNames';
import {useNavigation} from '@react-navigation/native';

const Item = (props) => {
  const {item, userId} = props;

  const navigate = useNavigation();

  return (
    <TouchableOpacity
      onPress={() => navigate.navigate(DEPOSIT, {method: item, userId})}
      style={styles.containerItem}>
      <Image source={{uri: item.logo_url}} style={styles.imgIcon} />
      <Text>{item.agent}</Text>
    </TouchableOpacity>
  );
};

export default React.memo(Item);

const styles = StyleSheet.create({
  containerItem: {
    width: WIDTHXD(460),
    height: HEIGHTXD(450),
    backgroundColor: 'white',
    marginTop: 20,
    borderRadius: 10,
    justifyContent: 'center',
    alignItems: 'center',
    shadowColor: '#000',
    shadowOffset: {
      width: 0,
      height: 1,
    },
    shadowOpacity: 0.25,
    shadowRadius: 2.84,
    elevation: 3,
  },
  imgIcon: {
    width: WIDTHXD(400),
    height: HEIGHTXD(300),
    marginBottom: 10,
    resizeMode: 'contain',
  },
});
