import React, {useState} from 'react';
import {
  View,
  Text,
  StyleSheet,
  Dimensions,
  TouchableOpacity,
  Alert,
  TouchableWithoutFeedback,
  Keyboard,
  KeyboardAvoidingView,
  Platform,
  ScrollView,
} from 'react-native';
import R from '../../../assets/R';
import HeaderBack from '../../../components/Header/HeaderBack';
import TextField from '../../../components/Input/TextField';
import TextMulti from '../../../components/Input/TextMulti';
import TextDisable from '../../../components/Input/TextDisable';
import {useNavigation} from '@react-navigation/native';
import {
  getFontXD,
  toPriceVnd,
  checkFormatArray,
} from '../../../Config/Functions';
import {connect} from 'react-redux';
import {showLoading, hideLoading} from '../../../actions/loadingAction';
import {walletDeposit} from '../../../apis/Functions/Deposit';
import TextMoney from '../../../components/Input/InputMoney';
import I18n from '../../../helper/i18/i18n';
import {OTPWALLET} from '../../../routers/ScreenNames';

import {getOTPApi} from '../../../apis/Functions/users';

const {width} = Dimensions.get('window');

const WalletDeposit = (props) => {
  const [amount, setAmount] = useState();
  const [notes, setNotes] = useState();
  const navigate = useNavigation();

  const onClick = async () => {
    const titles = [
      I18n.t('AmountOfMoney').toLowerCase(),
      I18n.t('Note').toLowerCase(),
    ];

    const index = checkFormatArray([amount, notes]);
    if (index === true) {
      props.showLoading();
      const res = await getOTPApi({
        platform: Platform.OS,
        otp_by: props.user.email,
      });
      props.hideLoading();
      if (res.data.code == 200) {
        navigate.navigate(OTPWALLET, {type: 'DEPOSIT', amount, notes});
      } else {
        setTimeout(() => {
          Alert.alert(I18n.t('Notification'), res.data.message);
        }, 500);
      }
    } else {
      Alert.alert(
        I18n.t('Notification'),
        I18n.t('Please_fill_in') + titles[index],
      );
    }
  };
  return (
    <KeyboardAvoidingView
      behavior={Platform.Os === 'ios' ? 'padding' : 'height'}
      style={{flex: 1, backgroundColor: 'white'}}
      keyboardVerticalOffset={-50}>
      <TouchableWithoutFeedback onPress={Keyboard.dismiss}>
        <View style={{flex: 1}}>
          <HeaderBack title={'InvestmentDeposit'} />
          <ScrollView showsVerticalScrollIndicator={false}>
            <View style={styles.container}>
              <View style={styles.wrapTop}>
                <View style={styles.itemTop}>
                  <Text style={styles.txtTitle}>{I18n.t('Wallet')}</Text>
                  <Text style={styles.txtMoney}>
                    {' '}
                    {props.user.current_money != 0
                      ? toPriceVnd(props.user.current_money)
                      : 0}{' '}
                  </Text>
                </View>
                <View style={{width: 1, backgroundColor: '#DBDBDB'}} />
                <View style={styles.itemTop}>
                  <Text style={styles.txtTitle}>CQG</Text>
                  <Text style={styles.txtMoney}>
                    {' '}
                    {props.user.current_cqg_money != 0
                      ? toPriceVnd(props.user.current_cqg_money)
                      : 0}{' '}
                    đ
                  </Text>
                </View>
              </View>
              <View style={styles.wrapBody}>
                {/* <TextDisable value={'10010101'} title={'Số tài khoản CQG'} /> */}
                <TextMoney
                  onChangeText={(val) => setAmount(val)}
                  title={I18n.t('AmountOfMoney')}
                  value={amount}
                />
                <TextMulti
                  onChangeText={(val) => setNotes(val)}
                  title={I18n.t('Note')}
                />
              </View>
            </View>
          </ScrollView>
          <View
            style={{
              paddingVertical: 10,
              justifyContent: 'center',
              alignItems: 'center',
            }}>
            <TouchableOpacity onPress={onClick} style={styles.btnSend}>
              <Text style={styles.txtSend}>{I18n.t('Deposit')}</Text>
            </TouchableOpacity>
          </View>
        </View>
      </TouchableWithoutFeedback>
    </KeyboardAvoidingView>
  );
};

const styles = StyleSheet.create({
  container: {
    backgroundColor: R.colors.white,
    marginVertical: 10,
    shadowColor: '#AFA9A9',
    shadowOffset: {
      width: 0,
      height: 1,
    },
    shadowOpacity: 0.25,
    shadowRadius: 1.84,
    elevation: 1,
  },
  wrapTop: {
    flexDirection: 'row',
    borderBottomWidth: 1,
    borderBottomColor: '#DBDBDB',
  },
  itemTop: {
    flex: 1,
    justifyContent: 'center',
    alignItems: 'center',
    paddingVertical: 20,
  },
  wrapBody: {
    paddingHorizontal: 10,
    paddingVertical: 20,
  },
  txtMoney: {
    color: '#1C6AF6',
    fontSize: getFontXD(52),
  },
  txtTitle: {
    color: R.colors.black,
    fontSize: getFontXD(42),
  },
  txtSend: {
    fontSize: getFontXD(42),
    color: R.colors.white,
    fontWeight: 'bold',
  },
  btnSend: {
    width: 140,
    height: 40,
    backgroundColor: R.colors.main,
    borderRadius: 10,
    justifyContent: 'center',
    alignItems: 'center',
  },
});

const mapStateToProps = (state) => {
  return {
    user: state.userReducer,
  };
};
export default connect(mapStateToProps, {showLoading, hideLoading})(
  WalletDeposit,
);
