import React, {useState} from 'react';
import {
  View,
  Text,
  Image,
  TouchableOpacity,
  StyleSheet,
  Alert,
  KeyboardAvoidingView,
  ScrollView,
  Platform,
  TouchableWithoutFeedback,
  Keyboard,
} from 'react-native';
import R from '../../../assets/R';
import I18n from '../../../helper/i18/i18n';
import moment from 'moment';
import AppText from '../../../components/AppText';

import TextField from '../../../components/Input/TextField';
import TextMulti from '../../../components/Input/TextMulti';
import PickerDate from '../../../components/Picker/PickerDate';
import PickerImg from '../../../components/Picker/PickerImg';

import {
  checkFormatArray,
  convertTime,
  convertDate,
  renderStatus,
  getFontXD,
} from '../../../Config/Functions';
import {connect} from 'react-redux';

const GeneralInfor = (props) => {
  return (
    <KeyboardAvoidingView
      behavior={Platform.Os === 'ios' ? 'padding' : 'height'}
      style={{flex: 1}}
      keyboardVerticalOffset={-50}>
      <TouchableWithoutFeedback onPress={Keyboard.dismiss}>
        <ScrollView showsVerticalScrollIndicator={false}>
          <View style={{flex: 1, paddingHorizontal: 10, paddingTop: 10}}>
            <View
              style={{
                width: '100%',
                paddingVertical: 10,
                flexDirection: 'row',
                justifyContent: 'space-between',
                alignItems: 'center',
              }}>
              <View style={{flex: 1}}>
                <AppText
                  i18nKey={'Status'}
                  style={{
                    fontSize: getFontXD(42),
                    color: R.colors.color777,
                    marginBottom: 5,
                  }}
                />
              </View>
              <View style={{flex: 1}}>{renderStatus(props.user.status)}</View>
            </View>
            <View style={{flexDirection: 'row'}}>
              <View style={{flex: 1}}>
                <TextField
                  editable={false}
                  value={props.user.l_name}
                  title={I18n.t('FirstLastName')}
                />
              </View>
              <View style={{width: 20}} />
              <View style={{flex: 1}}>
                <TextField
                  value={props.user.f_name}
                  editable={false}
                  title={I18n.t('Name')}
                />
              </View>
            </View>
            <TextField
              value={props.user.phone}
              isNumber={true}
              editable={false}
              title={I18n.t('PhoneNumber')}
            />
            <PickerDate
              valueString={convertDate(props.user.birthday)}
              disabled={true}
              title={I18n.t('Birth')}
            />
            <TextMulti
              value={props.user.address}
              editable={false}
              title={I18n.t('Address')}
            />
            <View style={{height: 100}} />
          </View>
        </ScrollView>
      </TouchableWithoutFeedback>
    </KeyboardAvoidingView>
  );
};

const styles = StyleSheet.create({
  btnNext: {
    borderRadius: 30,
    backgroundColor: '#1473E6',
    width: 50,
    height: 50,
    justifyContent: 'center',
    alignItems: 'center',
    marginTop: 20,
    alignSelf: 'flex-end',
    elevation: 2,
    shadowColor: '#000',
    shadowOffset: {
      width: 0,
      height: 1,
    },
    shadowOpacity: 0.15,
    shadowRadius: 1.84,
  },
});

const mapStateToProps = (state) => {
  return {
    user: state.userReducer,
  };
};
export default connect(mapStateToProps, {})(GeneralInfor);
