import React, {Component} from 'react';
import {View, Text, StyleSheet, TouchableOpacity, Linking} from 'react-native';
import {getFontXD, toPriceVnd} from '../../../Config/Functions';
import R from '../../../assets/R';
import AppText from '../../../components/AppText';
import I18n from '../../../helper/i18/i18n';

const Footer = (props) => {
  return (
    <View style={{flex: 1, paddingHorizontal: 10, marginTop: 10}}>
      <View style={{flexDirection: 'row', marginVertical: 5}}>
        <AppText i18nKey={'Open_account_demo'} style={styles.txtTitle} />
        <TouchableOpacity
          onPress={() =>
            Linking.openURL('https://mdemo.cqg.com/cqg/desktop/demorequest')
          }>
          <AppText i18nKey={'Here'} style={styles.txtLink} />
        </TouchableOpacity>
      </View>
      <Text style={styles.txtTitle}>
        {I18n.t('Provisional')}:{toPriceVnd(props.price)}
      </Text>
      <View
        style={{
          justifyContent: 'center',
          alignItems: 'center',
          marginVertical: 10,
        }}>
        <TouchableOpacity
          onPress={props.onClick}
          onClick
          style={styles.btnSend}>
          <AppText i18nKey={'Open_account'} style={styles.txtSend} />
        </TouchableOpacity>
      </View>
    </View>
  );
};

const styles = StyleSheet.create({
  txtSend: {
    fontSize: getFontXD(42),
    color: R.colors.white,
    fontWeight: 'bold',
  },
  btnSend: {
    width: 140,
    height: 40,
    backgroundColor: R.colors.main,
    borderRadius: 10,
    justifyContent: 'center',
    alignItems: 'center',
  },
  txtTitle: {
    fontSize: getFontXD(42),
    color: R.colors.black,
  },
  txtLink: {
    fontSize: getFontXD(42),
    color: R.colors.main,
    marginLeft: 10,
    borderBottomWidth: 1,
    borderBottomColor: R.colors.main,
  },
});

export default Footer;
