import React, {Fragment, useRef, useEffect, useState} from 'react';
import {SafeAreaView} from 'react-native';
import {NavigationContainer} from '@react-navigation/native';
import {createStackNavigator} from '@react-navigation/stack';

import TabNavigator from './TabNavigation';
import Login from '../Screens/Login/Login';

import AccountVerificaiton from '../Screens/AccountVerification/AccountVerification';
import Feedback from '../Screens/Feedback/Feedback';
import MethodPay from '../Screens/MethodPay/MethodPay';
import ServiceCustomer from '../Screens/ServiceCustomer/ServiceCustomer';
import Setting from '../Screens/Setting/Setting';

import BonusTeam from '../Screens/Menu/BonusTeam/BonusTeam';
import MyGroup from '../Screens/Menu/MyGroup/MyGroup';
import Payments from '../Screens/Menu/Payments/Payments';
import Rose from '../Screens/Menu/Rose/Rose';
import Profile from '../Screens/Menu/Profile/Profile';

import Withdraw from '../Screens/Action/Withdraw/Withdraw';
import Transfer from '../Screens/Action/Transfer/Transfer';
import Deposit from '../Screens/Action/Deposit/Deposit';
import History from '../Screens/Action/History/History';
import Authen from '../Screens/Authen/Authen';
import ForgotPassWord from '../Screens/Authen/ForgotPassword';
import ConfirmOTP from '../Screens/Authen/ConfirmOTP';
import ChooseMethod from '../Screens/Action/Deposit/ChooseMethod';

import NewPassWord from '../Screens/Authen/NewPassWord';
import ConfirmEmail from '../Screens/Authen/ConfirmEmail';
import Notification from '../Screens/Notification/Notification';
import DetailNew from '../Screens/NewFeed/DetailNew';
import AddMethodPay from '../Screens/MethodPay/AddMethod';
import Contract from '../Screens/Account/Contract';
import Wallet from '../Screens/Action/Wallet/Wallet';
import WalletDeposit from '../Screens/Action/Wallet/WalletDeposit';
import WalletWithdraw from '../Screens/Action/Wallet/WalletWithdraw';
import PacketCQG from '../Screens/Account/PacrtCQG/PacketCQG';
import MediaDetail from '../Screens/NewFeed/Media/MediaDetail';
import MethodPayDetail from '../Screens/MethodPay/MethodPayDetail';
import LegaDocument from '../Screens/LegalDocument/LegalDocument';
import Business from '../Screens/LegalDocument/Business';
import Customer from '../Screens/LegalDocument/Customer';
import Partner from '../Screens/LegalDocument/Partner';
import SnackBar from '../components/SnackBar';
import DetailHistory from '../Screens/Action/History/DetailHistory';
import ProductDetail from '../Screens/Transaction/ProductDetail/ProductDetail';
import RegisterOTP from '../Screens/Authen/RegisterOTP';

import * as ScreenName from './ScreenNames';

const Stack = createStackNavigator();

import {enableScreens} from 'react-native-screens';

enableScreens();

function MyStack(props) {
  return (
    <Stack.Navigator
      screenOptions={{
        headerStatusBarHeight: 0,
      }}
      headerMode={'none'}
      initialRouteName={ScreenName.AUTHEN}>
      <Stack.Screen name={ScreenName.LOGINSCREEN} component={Login} />
      <Stack.Screen name={ScreenName.HISTORYDETAIL} component={DetailHistory} />
      <Stack.Screen name={ScreenName.LEGALDOCUMENT} component={LegaDocument} />
      <Stack.Screen name={ScreenName.NOTIFICATION} component={Notification} />
      <Stack.Screen name={ScreenName.REGISTEROTP} component={RegisterOTP} />

      <Stack.Screen name={ScreenName.LEGALBUSINESS} component={Business} />
      <Stack.Screen name={ScreenName.LEGALCUSTOMER} component={Customer} />
      <Stack.Screen name={ScreenName.LEGALPARTNER} component={Partner} />

      <Stack.Screen name={ScreenName.MEDIADETAIL} component={MediaDetail} />
      <Stack.Screen name={ScreenName.TABNAVIGATOR} component={TabNavigator} />
      <Stack.Screen name={ScreenName.PACKETCQG} component={PacketCQG} />
      <Stack.Screen name={ScreenName.WALLET} component={Wallet} />
      <Stack.Screen name={ScreenName.WALLETDEPOSIT} component={WalletDeposit} />
      <Stack.Screen
        name={ScreenName.METHODPAYDETAIL}
        component={MethodPayDetail}
      />
      <Stack.Screen
        name={ScreenName.WALLETWITHDRAW}
        component={WalletWithdraw}
      />

      <Stack.Screen name={ScreenName.DETAILNEW} component={DetailNew} />
      <Stack.Screen name={ScreenName.ADDMETHODPAY} component={AddMethodPay} />
      <Stack.Screen
        name={ScreenName.AccountVerification}
        component={AccountVerificaiton}
      />
      <Stack.Screen name={ScreenName.CONTRACT} component={Contract} />
      <Stack.Screen name={ScreenName.CONFIRMOTP} component={ConfirmOTP} />

      <Stack.Screen name={ScreenName.FEEDBACK} component={Feedback} />
      <Stack.Screen name={ScreenName.AUTHEN} component={Authen} />
      <Stack.Screen name={ScreenName.METHODPAY} component={MethodPay} />

      <Stack.Screen
        name={ScreenName.SERVICECUSTOMER}
        component={ServiceCustomer}
      />
      <Stack.Screen name={ScreenName.CHOOSEMETHOD} component={ChooseMethod} />
      <Stack.Screen name={ScreenName.BONUSTEAM} component={BonusTeam} />
      <Stack.Screen name={ScreenName.MYGROUP} component={MyGroup} />
      <Stack.Screen name={ScreenName.PAYMENTS} component={Payments} />
      <Stack.Screen name={ScreenName.ROSE} component={Rose} />
      <Stack.Screen name={ScreenName.SETTING} component={Setting} />

      <Stack.Screen name={ScreenName.PROFILE} component={Profile} />
      <Stack.Screen name={ScreenName.WITHDRAW} component={Withdraw} />
      <Stack.Screen name={ScreenName.DEPOSIT} component={Deposit} />
      <Stack.Screen name={ScreenName.TRANSFER} component={Transfer} />
      <Stack.Screen name={ScreenName.HISTORY} component={History} />

      <Stack.Screen name={ScreenName.CONFIRMEMAIL} component={ConfirmEmail} />
      <Stack.Screen name={ScreenName.NEWPASSWORD} component={NewPassWord} />
      <Stack.Screen name={ScreenName.PRODUCTDETAIL} component={ProductDetail} />

      <Stack.Screen
        name={ScreenName.FORGOTPASSWORD}
        component={ForgotPassWord}
      />
    </Stack.Navigator>
  );
}

export default function App() {
  return (
    <Fragment>
      <NavigationContainer independent={true}>
        <MyStack />
      </NavigationContainer>
    </Fragment>
  );
}
