import React from 'react'
import {
    View,
    Text,
    StyleSheet
} from 'react-native'
import R from '../assets/R';
import {getFontXD, HEIGHTXD, WIDTHXD} from '../Config/Functions';

const TextField = (props) => {
    return (
        <View style={[styles.row, { paddingVertical: WIDTHXD(15) }]}>
            <Text style={styles.title}>{props.title}</Text>
            <Text style={styles.content}>{props.content}</Text>
        </View>
    )
}
export default TextField
const styles = StyleSheet.create({
    row: {
        paddingHorizontal: HEIGHTXD(30),
        flexDirection: 'row',
    },
    title: {
        flex: 2.7,
        fontSize: getFontXD(36),
        color: R.colors.color777
    },
    content: {
        flex: 3.5,
        fontSize: getFontXD(36),
        color: R.colors.black,
    },
})
