import React from 'react';
import {
  View,
} from 'react-native';
import HeaderBack from '../../../components/Header/HeaderBack';
import ContractDescription from './Tab/ContractDescription/ContractDescription';
import QualityStandard from './Tab/QualityStandard/QualityStandard';
import {createMaterialTopTabNavigator} from '@react-navigation/material-top-tabs';
import {getFontXD} from '../../../Config/Functions';
const Tab = createMaterialTopTabNavigator();
import I18n from '../../../helper/i18/i18n';

const ProductDetailView = (props) => {
    console.log('ProductDetailView', props)
  return (
    <View style={{flex: 1}}>
      <HeaderBack isWhite={true} children={props.name} />

      <Tab.Navigator
        initialRouteName="ContractDescription"
        tabBarOptions={{
          inactiveTintColor: '#929292',
          activeTintColor: '#1473E6',
          labelStyle: {fontSize: getFontXD(36)},
          style: {backgroundColor: 'white'},
        }}>
        <Tab.Screen
          name="ContractDescription"
          component={ContractDescription}
          initialParams={props}
          options={{tabBarLabel: I18n.t('ContractDescription')}}
        />
        <Tab.Screen
          name="QualityStandard"
          component={QualityStandard}
          initialParams={props}
          options={{tabBarLabel: I18n.t('QualityStandard')}}
        />
      </Tab.Navigator>
    </View>
  );
};

export default ProductDetailView;
