import React from 'react';
import {Alert} from 'react-native';

import SettingView from './SettingView';
import {updateLangugeApi} from '../../apis/Functions/users';
import I18n from '../../helper/i18/i18n';
import {connect} from 'react-redux';
import {showLoading, hideLoading} from '../../actions/loadingAction';

const Setting = (props) => {
  const convertKeyLanguage = (key) => {
    if (key == 'en') return 'ENGLISH';
    return 'VIETNAMESE';
  };

  const updateLangue = async (key) => {
    props.showLoading();
    const res = await updateLangugeApi({
      platform: Platform.OS,
      language: convertKeyLanguage(key),
    });
    props.hideLoading();
    if (res.data.code == 200) {
      setTimeout(() => {
        Alert.alert(I18n.t('Notification'), res.data.message);
      }, 500);
    } else {
      setTimeout(() => {
        Alert.alert(I18n.t('Notification'), res.data.message);
      }, 500);
    }
  };

  return <SettingView updateLangue={updateLangue} />;
};

const mapStateToProps = (state) => {
  return {
    user: state.userReducer,
  };
};
export default connect(mapStateToProps, {
  showLoading,
  hideLoading,
})(Setting);
