import React, {useState, useEffect} from 'react';
import {View, Text, StyleSheet} from 'react-native';
import R from '../../assets/R';
import AppText from '../../components/AppText';
import TextMulti from '../../components/Input/TextMulti';
import I18n from '../../helper/i18/i18n';

import HeaderBack from '../../components/Header/HeaderBack';
import {getFontXD, HEIGHTXD, WIDTHXD} from '../../Config/Functions';
import {TouchableOpacity} from 'react-native-gesture-handler';

const ServiceCustomerView = (props) => {
  const [content, setContent] = useState('');
  const [data, setData] = useState({
    company: 'CÔNG TY CP TƯ VẤN ĐẦU TƯ DCV.',
    address:
      'Tầng L2, Tòa Nhà Mỹ Sơn, Số 62 Nguyễn Huy Tưởng, Phường Thanh Xuân Trung, Quận Thanh Xuân, Thành Phố Hà Nội',
    email: 'sale@dcv.vn',
    website: 'https://dcvinvest.com',
    hotline: '024.9999.8669',
    time:
      'Thứ 2 - Thứ 6:  08:00 - 18:00 \nThứ 7:                10:00 - 14:00 \nChủ nhật:          09:00 - 12:00',
  });
  return (
    <View style={{flex: 1}}>
      <HeaderBack title={'CustomerCare'} />
      <View
        style={{
          flex: 1,
          paddingHorizontal: 10,
          paddingTop: 10,
        }}>
        <AppText i18nKey={'HaNoiOffice'} style={styles.title} />
        <Text style={styles.txtContent}>{data.company}</Text>

        <AppText i18nKey={'Address'} style={styles.title} />
        <Text style={styles.txtContent}>{data.address}</Text>

        <View style={styles.row}>
          <AppText i18nKey={'Email'} style={styles.title} />
          <Text style={styles.txtContent}> {data.email}</Text>
        </View>
        <View style={styles.row}>
          <Text style={styles.title}>Website: </Text>
          <Text style={styles.txtContent}>{data.website}</Text>
        </View>

        <AppText i18nKey={'HotLine'} style={styles.title} />
        <Text style={styles.txtContent}>{data.hotline}</Text>

        <AppText i18nKey={'WorkingTime'} style={styles.title} />
        <Text style={styles.txtContent}>{data.time}</Text>

        <View style={{marginTop: 20, flex: 1}}>
          <TextMulti
            onChangeText={(val) => setContent(val)}
            title={I18n.t('ContentRequire')}
          />
        </View>
        <View
          style={{
            justifyContent: 'center',
            alignItems: 'center',
            marginBottom: 20,
          }}>
          <TouchableOpacity style={styles.btn}>
            <AppText style={styles.txtBtn} i18nKey={'Send'} />
          </TouchableOpacity>
        </View>
      </View>
    </View>
  );
};

const styles = StyleSheet.create({
  title: {
    fontSize: getFontXD(42),
    color: R.colors.main,
    marginTop: 5,
  },
  txtContent: {
    fontSize: getFontXD(42),
    marginTop: 5,
  },
  row: {
    flexDirection: 'row',
  },
  btn: {
    width: WIDTHXD(500),
    height: HEIGHTXD(120),
    justifyContent: 'center',
    alignItems: 'center',
    backgroundColor: R.colors.main,
    borderRadius: 5,
  },
  txtBtn: {
    fontSize: getFontXD(46),
    color: R.colors.white,
    fontWeight: 'bold',
  },
});

export default ServiceCustomerView;
