import React from 'react';
import {View, Text, StyleSheet, TouchableOpacity} from 'react-native';
import R from '../../assets/R';
import HeaderBack from '../../components/Header/HeaderBack';
import {getFontXD} from '../../Config/Functions';
import {useNavigation} from '@react-navigation/native';
import AppText from '../../components/AppText';

const Customer = (props) => {
  const navigate = useNavigation();
  return (
    <View style={{flex: 1}}>
      <HeaderBack title={'Customer'} />
      <View style={styles.container}>
        <AppText
          i18nKey={'Features_develop'}
          style={{
            fontSize: 18,
            fontWeight: 'bold',
            textAlign: 'center',
          }}
        />
      </View>
    </View>
  );
};

export default Customer;

const styles = StyleSheet.create({
  txtTitle: {
    fontSize: getFontXD(42),
    color: '#001C51',
    paddingVertical: 15,
  },
  containerItem: {
    borderBottomWidth: 0.7,
    borderBottomColor: R.colors.borderGray,
    paddingHorizontal: 20,
  },
  container: {
    flex: 1,
    justifyContent: 'center',
    alignItems: 'center',

    paddingTop: 20,
  },
});
