import React from 'react';
import {
    View,
    Text,
    StyleSheet,
    Image,
} from 'react-native';
import {
    getFontXD,
    HEIGHTXD,
    WIDTHXD,
} from '../../Config/Functions';
import R from '../../assets/R';
import Block from '../../components/Block';
import * as Progress from 'react-native-progress';

const ItemPrice = (props) => {
    const {item, isEndItem} = props;
    return (
        <View style={[styles.container, isEndItem && {marginBottom: HEIGHTXD(100)}, {paddingBottom: HEIGHTXD(20)}]}>
            <Block flex={1} row>
                <View style={{flex: 0.8, flexDirection: 'column', justifyContent: 'center'}}>
                    <Text style={[styles.txtBlack, {marginBottom: HEIGHTXD(5)}]}>
                        {item.name}
                    </Text>
                    <Progress.Bar progress={item.change}
                                  width={WIDTHXD(200)}
                                  height={HEIGHTXD(8)}
                                  color={R.colors.green}
                                  backgroundColor={R.colors.red}
                                  borderWidth={0}
                                  borderRadius={0}
                    />
                </View>
                <Block padding={[0, 0]} space={'between'} flex={1}>
                    <View
                        style={{
                            flex: 1,
                            flexDirection: 'column',
                            justifyContent: 'space-between',
                            alignItems: 'flex-end',
                        }}>
                        <View
                            style={{
                                flex: 1,
                                flexDirection: 'row',
                                justifyContent: 'space-between',
                                alignItems: 'center',
                            }}>
                            <Image source={item.isUp ? R.images.iconTriangleUp : R.images.iconTriangleDown} style={styles.imgIcon} />
                            <Text style={[styles.txtBlack, {flexWrap: 'wrap', color: item.isUp ? R.colors.green : R.colors.red2}]}>
                                {item.change}
                            </Text>
                        </View>
                        <Text style={[styles.txtMoney, {color: item.isUp ? R.colors.green : R.colors.red2}]}>{`${item.change}%`}</Text>
                    </View>
                </Block>
                <Block padding={[0, 0]} space={'between'} flex={1}>
                    <View
                        style={{
                            flex: 1,
                            flexDirection: 'column',
                            justifyContent: 'space-between',
                            alignItems: 'flex-end',
                        }}>
                        <View
                            style={{
                                flex: 1,
                                flexDirection: 'row',
                                justifyContent: 'space-between',
                                alignItems: 'center',
                            }}>

                            <Text style={[styles.txtBlack, {flexWrap: 'wrap'}]}
                                  ellipsizeMode='tail'>
                                {item.openPrice}
                            </Text>
                            <Image source={item.isUp ? R.images.iconTriangleUp : R.images.iconTriangleDown} style={styles.imgIcon} />
                        </View>
                        <View
                            style={{
                                flex: 1,
                                flexDirection: 'row',
                                justifyContent: 'space-between',
                                alignItems: 'center',
                            }}>
                            <Text style={[styles.txtMoney, {color: R.colors.gray}]}>{item.closePrice}</Text>
                            <Image source={R.images.iconCheck2} style={styles.imgIcon} />
                        </View>
                    </View>
                </Block>
                <Block padding={[0, 0]} flex={1}>
                    <View
                        style={{
                            flex: 1,
                            flexDirection: 'column',
                            justifyContent: 'center',
                            alignItems: 'flex-end',
                        }}>
                        <View
                            style={{
                                flex: 1,
                                flexDirection: 'row',
                                justifyContent: 'center',
                            }}>
                            <Text style={[styles.txtBlack, {flexWrap: 'wrap'}]}>
                                {item.highPrice}
                            </Text>
                            <Text style={[styles.txtGray, {flexWrap: 'wrap'}]}>
                                H
                            </Text>
                        </View>
                        <View
                            style={{
                                flex: 1,
                                flexDirection: 'row',
                                justifyContent: 'center',
                            }}>
                            <Text style={styles.txtMoney}>{item.lowPrice}</Text>
                            <Text style={[styles.txtGray, {flexWrap: 'wrap'}]}>
                                L
                            </Text>
                        </View>
                    </View>
                </Block>
            </Block>
            <Text style={[styles.txtTime]}>
                {item.time}</Text>
            <View style={{height: HEIGHTXD(1), backgroundColor: R.colors.gray, marginTop: HEIGHTXD(3), marginBottom: HEIGHTXD(3)}}></View>
        </View>
    );
};

export default ItemPrice;

const styles = StyleSheet.create({
    container: {
        shadowColor: '#000',
        backgroundColor: R.colors.white,
        borderRadius: HEIGHTXD(30),
        marginHorizontal: WIDTHXD(30),
    },

    wrapLeft: {
        width: WIDTHXD(16),
        borderTopLeftRadius: HEIGHTXD(30),
        borderBottomStartRadius: HEIGHTXD(30),
    },
    txtTitle: {
        fontSize: getFontXD(42),
        color: R.colors.black,
        fontWeight: 'bold',
    },
    txt: {
        fontSize: getFontXD(36),
        color: 'black',
    },
    rowBet: {
        flexDirection: 'row',
        justifyContent: 'space-between',
        alignItems: 'center',
    },
    txtBlack: {
        fontSize: getFontXD(34),
        color: 'black',
    },

    txtGray: {
        fontSize: getFontXD(28),
        color: R.colors.gray,
    },

    txtTime: {
        marginTop: HEIGHTXD(6),
        fontSize: getFontXD(32),
        color: 'black',
    },
    txtMoney: {
        fontSize: getFontXD(34),
    },
    imgIcon: {
        width: WIDTHXD(20),
        height: WIDTHXD(20),
        resizeMode: 'contain',
    }
});
