import React from 'react';
import {
  View,
  Text,
  StyleSheet,
  TouchableOpacity,
  Image,
  Alert,
} from 'react-native';
import {
  getFontXD,
  HEIGHTXD,
  WIDTHXD,
  toPriceVnd,
} from '../../../Config/Functions';
import R from '../../../assets/R';
import Block from '../../../components/Block';

const Item = (props) => {
  const {item, isEndItem} = props;
  return (
    <View style={[styles.container, isEndItem && {marginBottom: HEIGHTXD(100)}]}>
      <TouchableOpacity onPress={() => props.onPress(item)}>
        <Block flex={1} row>
          <View style={styles.wrapDate}>
            <Image source={{uri: item.image_path}} style={styles.imgIcon} />
          </View>
          <Block padding={[5, 10]} space={'between'} flex={1}>
            <View
              style={{
                flex: 1,
                flexDirection: 'row',
                justifyContent: 'space-between',
              }}>
              <Text numberOfLines={2} style={[styles.txtBlack, {flexWrap: 'wrap', flex: 1}]} numberOfLines={1} ellipsizeMode='tail'>
                {item.name}
              </Text>
              <Text style={styles.txtMoney}>{item.escrow > 0 ? toPriceVnd(item.escrow) : 0}</Text>
            </View>
            <Text style={styles.txt}>{item.code}</Text>
          </Block>
        </Block>
      </TouchableOpacity>
    </View>
  );
};

export default Item;

const styles = StyleSheet.create({
  container: {
    paddingVertical: 10,
    shadowColor: '#000',
    shadowOffset: {
      width: 0,
      height: 2,
    },
    shadowOpacity: 0.25,
    shadowRadius: 3.84,
    elevation: 5,
    marginHorizontal: 10,
    backgroundColor: R.colors.white,
    borderRadius: HEIGHTXD(30),
    marginVertical: HEIGHTXD(15)
  },

  wrapLeft: {
    width: WIDTHXD(16),
    borderTopLeftRadius: HEIGHTXD(30),
    borderBottomStartRadius: HEIGHTXD(30),
  },
  wrapDate: {
    justifyContent: 'center',
    paddingLeft: 10,
  },
  txtTitle: {
    fontSize: getFontXD(42),
    color: R.colors.black,
  },
  txt: {
    fontSize: getFontXD(36),
    color: R.colors.black,
  },
  rowBet: {
    flexDirection: 'row',
    justifyContent: 'space-between',
    alignItems: 'center',
  },
  txtBlack: {
    fontSize: getFontXD(50),
    color: 'black',
  },
  imgIcon: {
    width: WIDTHXD(178),
    height: WIDTHXD(178),
    resizeMode: 'cover',
  },
  txtMoney: {
    fontSize: getFontXD(42),
    color: R.colors.main,
  },
});
