import * as React from 'react';
import {View, useWindowDimensions, Button} from 'react-native';
import {TabView, SceneMap} from 'react-native-tab-view';
import FirstRoute from './Tab1/Tab1';
import SecondRoute from './Calendar/Calendar';
import Notification from '../../Screens/Notification/Notification';
import Tab2 from './Tab2/Tab2';
const renderScene = SceneMap({
  first: FirstRoute,
  second: SecondRoute,
  three: Notification,
  four: Tab2,
  five: FirstRoute,
});

export default function TabViewExample() {
  const layout = useWindowDimensions();

  const [index, setIndex] = React.useState(0);
  const [routes] = React.useState([
    {key: 'first', title: 'First'},
    {key: 'second', title: 'Second'},
    {key: 'three', title: 'three'},
    {key: 'four', title: 'four'},
    {key: 'five', title: 'five'},
  ]);

  return (
    <TabView
      navigationState={{index, routes}}
      renderScene={renderScene}
      onIndexChange={setIndex}
      initialLayout={{width: layout.width}}
    />
  );
}
