import React, {Component} from 'react';
import {
  View,
  Text,
  StyleSheet,
  Image,
  TouchableOpacity,
  ImageBackground,
} from 'react-native';
import R from '../../../assets/R';
import {getFontXD} from '../../../Config/Functions';
import Icon from 'react-native-vector-icons/AntDesign';
import {useNavigation} from '@react-navigation/native';
import {MEDIADETAIL} from '../../../routers/ScreenNames';
const Item = (props) => {
  const navigate = useNavigation();
  const {title, time_ago, poster, view_count, id, video_id} = props.item;

  return (
    <TouchableOpacity
      onPress={() => navigate.navigate(MEDIADETAIL, {id, video_id, title})}
      style={styles.container}>
      <ImageBackground
        resizeMode={'contain'}
        source={{uri: poster}}
        imageStyle={{borderRadius: 5}}
        style={styles.img}>
        <Icon
          name={'playcircleo'}
          color={R.colors.white}
          size={getFontXD(62)}
        />
      </ImageBackground>
      <Text style={styles.txtTitle} numberOfLines={2}>
        {title}
      </Text>
      <View style={{flexDirection: 'row', justifyContent: 'space-between'}}>
        <Text style={{color: '#8E8C8C'}}>{time_ago}</Text>
        <View style={styles.row}>
          <Icon name={'eye'} size={getFontXD(36)} color={'#8E8C8C'} />
          <Text style={{color: '#8E8C8C'}}>{view_count}</Text>
        </View>
      </View>
    </TouchableOpacity>
  );
};

const styles = StyleSheet.create({
  container: {
    width: 250,
    paddingVertical: 5,
    marginRight: 15,
  },
  img: {
    width: 250,
    height: 200,
    borderRadius: 5,
    justifyContent: 'center',
    alignItems: 'center',
  },
  txtTitle: {
    fontSize: getFontXD(42),
    marginVertical: 5,
  },
  row: {
    flexDirection: 'row',
    alignItems: 'center',
    width: 40,
    justifyContent: 'space-around',
  },
});

export default Item;
