import React, {useState, useEffect} from 'react';

import MethodPayView from './MethodPayView';
import {getListWidthDraw} from '../../apis/Functions/Widthdraw';
import {useNavigation} from '@react-navigation/native';
import I18n from '../../helper/i18/i18n';

const MethodPay = (props) => {
  const [data, setData] = useState([]);
  const [isRefresh, setRefresh] = useState(false);
  const navigation = useNavigation();

  useEffect(() => {
    const unsubscribe = navigation.addListener('focus', () => {
      getData();
    });

    return unsubscribe;
  }, [navigation]);

  const onRefresh = () => {
    getData();
  };

  const getData = async () => {
    setRefresh(true);
    const res = await getListWidthDraw({
      platform: Platform.OS,
    });
    setRefresh(false);
    if (res.data.code == 200 && res.data.data) {
      setData(res.data.data);
    } else {
      Alert.alert(I18n.t('Notification'), I18n.t('Can_not_get_data'));
    }
  };

  return (
    <MethodPayView
      onRefresh={onRefresh}
      listMethod={data}
      isRefresh={isRefresh}
    />
  );
};

export default MethodPay;
