import React from 'react';
import {View, Text, StyleSheet, TouchableOpacity, Image} from 'react-native';
import {
  getFontXD,
  HEIGHTXD,
  WIDTHXD,
  toPriceVnd,
  getWidth,
} from '../../Config/Functions';
import R from '../../assets/R';
import Block from '../../components/Block';
import Icon from 'react-native-vector-icons/MaterialCommunityIcons';
import {useNavigation} from '@react-navigation/native';
import {METHODPAYDETAIL} from '../../routers/ScreenNames';
const Item = (props) => {
  const {item} = props;
  return (
    <TouchableOpacity onPress={() => props.onPress(item)}>
      <View
        style={[
          styles.container,
          {marginBottom: props.isEndItem ? HEIGHTXD(100) : HEIGHTXD(15)},
        ]}>
        <Block flex={1} row center padding={[HEIGHTXD(10), WIDTHXD(10)]}>
          <Image source={{uri: item.logo}} style={styles.imgIcon} />
          <Block padding={[0, 10]}>
            <Text style={styles.txtBig}>{item.title}</Text>
            <Block space={'between'} row flex={1}>
              <Block>
                <Text style={styles.txtRight}>{item.code}</Text>
                <Text style={styles.txtRight}>{item.name}</Text>
              </Block>
            </Block>
          </Block>
        </Block>
      </View>
    </TouchableOpacity>
  );
};

export default React.memo(Item);

const styles = StyleSheet.create({
  container: {
    marginTop: HEIGHTXD(10),
    shadowColor: '#000',
    shadowOffset: {
      width: 0,
      height: 1,
    },
    shadowOpacity: 0.25,
    shadowRadius: 3.84,
    elevation: 2,
    marginHorizontal: HEIGHTXD(10),
    backgroundColor: R.colors.white,
    marginBottom: 10,
    borderRadius: HEIGHTXD(15),
    width: getWidth() - WIDTHXD(105),
  },

  wrapLeft: {
    width: WIDTHXD(16),
    borderTopLeftRadius: HEIGHTXD(30),
    borderBottomStartRadius: HEIGHTXD(30),
  },
  wrapDate: {
    justifyContent: 'center',
    paddingLeft: 10,
  },
  txtTitle: {
    fontSize: getFontXD(42),
    color: R.colors.black,
    fontWeight: 'bold',
  },
  txt: {
    fontSize: getFontXD(39),
    color: '#929292',
    fontStyle: 'italic',
  },
  rowBet: {
    flexDirection: 'row',
    justifyContent: 'space-between',
    alignItems: 'center',
  },
  txtBlack: {
    fontSize: getFontXD(42),
    color: 'black',
  },
  imgIcon: {
    width: WIDTHXD(200),
    height: WIDTHXD(200),
    resizeMode: 'contain',
  },
  txtLeft: {
    fontSize: getFontXD(36),
    color: '#929292',
    marginBottom: 5,
  },
  txtBig: {
    fontSize: getFontXD(42),
    color: '#00359C',
  },
  txtRight: {
    fontSize: getFontXD(36),
    marginBottom: 5,
  },
});
