import React from 'react';
import {
  View,
  Text,
  KeyboardAvoidingView,
  ScrollView,
  Platform,
} from 'react-native';
import HeaderBack from '../../../components/Header/HeaderBack';
import GeneralInfor from './Tab/GeneralInfor';
import CQG from './Tab/CQG';
import {createMaterialTopTabNavigator} from '@react-navigation/material-top-tabs';
import {getFontXD} from '../../../Config/Functions';
const Tab = createMaterialTopTabNavigator();
import I18n from '../../../helper/i18/i18n';

const ProfileView = (props) => {
  return (
    <View style={{flex: 1}}>
      <HeaderBack isWhite={true} title={'MyProfile'} />

      <Tab.Navigator
        initialRouteName="GeneralInfor"
        tabBarOptions={{
          inactiveTintColor: '#929292',
          activeTintColor: '#1473E6',
          labelStyle: {fontSize: getFontXD(36)},
          style: {backgroundColor: 'white'},
        }}>
        <Tab.Screen
          name="GeneralInfor"
          component={GeneralInfor}
          options={{tabBarLabel: I18n.t('GeneralInformation')}}
        />
        <Tab.Screen
          name="CQG"
          component={CQG}
          options={{tabBarLabel: I18n.t('AccountCQG')}}
        />
      </Tab.Navigator>
    </View>
  );
};

export default ProfileView;
