import React from 'react';
import {
    View,
    Text,
    StyleSheet,
    TouchableOpacity,
    Image,
    Alert,
} from 'react-native';
import {
    getFontXD,
    HEIGHTXD,
    WIDTHXD,
} from '../../Config/Functions';
import R from '../../assets/R';
import Block from '../../components/Block';
import AntDesign from 'react-native-vector-icons/AntDesign';
import * as Progress from 'react-native-progress';

const ItemPrice = (props) => {
    const {item, isEndItem} = props;
    return (
        <View style={[styles.container, isEndItem && {marginBottom: HEIGHTXD(100)}, {paddingBottom: HEIGHTXD(20)}]}>
            <Block flex={1} row>
                <View style={{flex: 0.8, flexDirection: 'column', justifyContent: 'center'}}>
                    <Text style={[styles.txtBlack, {marginBottom: HEIGHTXD(5)}]}>
                        {item.name}
                    </Text>
                    <Progress.Bar progress={item.change}
                                  width={WIDTHXD(200)}
                                  height={HEIGHTXD(8)}
                                  color={R.colors.green}
                                  backgroundColor={R.colors.red}
                                  borderWidth={0}
                                  borderRadius={0}
                    />
                </View>
                <Block padding={[0, 0]} space={'between'} flex={1}>
                    <View
                        style={{
                            flex: 1,
                            flexDirection: 'column',
                            justifyContent: 'space-between',
                            alignItems: 'flex-end',
                        }}>
                        <View
                            style={{
                                flex: 1,
                                flexDirection: 'row',
                                justifyContent: 'space-between',
                                alignItems: 'center',
                            }}>
                            <AntDesign
                                name="caretup"
                                size={WIDTHXD(25)}
                                color={R.colors.green}
                            />
                            <Text style={[styles.txtBlack, {flexWrap: 'wrap', color: R.colors.green}]}>
                                {item.change}
                            </Text>
                        </View>
                        <Text style={[styles.txtMoney, {color: R.colors.green}]}>{`${item.change}%`}</Text>
                    </View>
                </Block>
                <Block padding={[0, 0]} space={'between'} flex={1}>
                    <View
                        style={{
                            flex: 1,
                            flexDirection: 'column',
                            justifyContent: 'space-between',
                            alignItems: 'flex-end',
                        }}>
                        <View
                            style={{
                                flex: 1,
                                flexDirection: 'row',
                                justifyContent: 'space-between',
                                alignItems: 'center',
                            }}>

                            <Text style={[styles.txtBlack, {flexWrap: 'wrap'}]}
                                  ellipsizeMode='tail'>
                                {item.openPrice}
                            </Text>
                            <AntDesign
                                name="caretup"
                                size={WIDTHXD(25)}
                                color={R.colors.green}
                            />
                        </View>
                        <View
                            style={{
                                flex: 1,
                                flexDirection: 'row',
                                justifyContent: 'space-between',
                                alignItems: 'center',
                            }}>
                            <Text style={[styles.txtMoney, {color: R.colors.gray}]}>{item.closePrice}</Text>
                            <AntDesign
                                name="check"
                                size={WIDTHXD(25)}
                                color={R.colors.gray}
                            />
                        </View>
                    </View>
                </Block>
                <Block padding={[0, 0]} flex={1}>
                    <View
                        style={{
                            flex: 1,
                            flexDirection: 'column',
                            justifyContent: 'center',
                            alignItems: 'flex-end',
                        }}>
                        <View
                            style={{
                                flex: 1,
                                flexDirection: 'row',
                                justifyContent: 'center',
                            }}>
                            <Text style={[styles.txtBlack, {flexWrap: 'wrap'}]}>
                                {item.highPrice}
                            </Text>
                            <Text style={[styles.txtGray, {flexWrap: 'wrap'}]}>
                                H
                            </Text>
                        </View>
                        <View
                            style={{
                                flex: 1,
                                flexDirection: 'row',
                                justifyContent: 'center',
                            }}>
                            <Text style={styles.txtMoney}>{item.lowPrice}</Text>
                            <Text style={[styles.txtGray, {flexWrap: 'wrap'}]}>
                                L
                            </Text>
                        </View>
                    </View>
                </Block>
            </Block>
            <Text style={[styles.txtTime]}>
                {item.time}</Text>
            <View style={{height: HEIGHTXD(1), backgroundColor: R.colors.gray, marginTop: HEIGHTXD(3), marginBottom: HEIGHTXD(3)}}></View>
        </View>
    );
};

export default ItemPrice;

const styles = StyleSheet.create({
    container: {
        shadowColor: '#000',
        backgroundColor: R.colors.white,
        borderRadius: HEIGHTXD(30),
        marginHorizontal: WIDTHXD(30),
    },

    wrapLeft: {
        width: WIDTHXD(16),
        borderTopLeftRadius: HEIGHTXD(30),
        borderBottomStartRadius: HEIGHTXD(30),
    },
    txtTitle: {
        fontSize: getFontXD(42),
        color: R.colors.black,
        fontWeight: 'bold',
    },
    txt: {
        fontSize: getFontXD(36),
        color: 'black',
    },
    rowBet: {
        flexDirection: 'row',
        justifyContent: 'space-between',
        alignItems: 'center',
    },
    txtBlack: {
        fontSize: getFontXD(34),
        color: 'black',
    },

    txtGray: {
        fontSize: getFontXD(28),
        color: R.colors.gray,
    },

    txtTime: {
        marginTop: HEIGHTXD(6),
        fontSize: getFontXD(32),
        color: 'black',
    },
    imgIcon: {
        width: WIDTHXD(150),
        height: WIDTHXD(150),
        resizeMode: 'cover',
        marginLeft: WIDTHXD(35),
    },
    txtMoney: {
        fontSize: getFontXD(34),
    },
});
