import React, {useEffect, useState} from 'react';
import {View, Alert, Platform} from 'react-native';
import {connect} from 'react-redux';
import {getTransaction} from '../../apis/Functions/users';
import {getImagesHome} from '../../apis/Functions/General';
import I18n from '../../helper/i18/i18n';

import HomeView from './HomeView';
import {getListCategoryProduct} from '../../apis/Functions/Transaction';
const Home = (props) => {
    const [data, setData] = useState({total_deposit: 0, total_withdraw: 0});
    const [dataPrice, setDataPrice] = useState([
        {name: 'GCEM21', change: 0.2, changePercent: 0.1, openPrice: 1777.2, closePrice: 17778.3, highPrice: 1778.9, lowPrice: 1777, time: 'Gold (Globex): June 2021'},
        {name: 'GCEM21', change: 0.5, changePercent: 0.1, openPrice: 1777.2, closePrice: 17778.3, highPrice: 1778.9, lowPrice: 1777, time: 'Gold (Globex): June 2021'},
        {name: 'GCEM21', change: 0.1, changePercent: 0.1, openPrice: 1777.2, closePrice: 17778.3, highPrice: 1778.9, lowPrice: 1777, time: 'Gold (Globex): June 2021'},
        {name: 'GCEM21', change: 0.6, changePercent: 0.1, openPrice: 1777.2, closePrice: 17778.3, highPrice: 1778.9, lowPrice: 1777, time: 'Gold (Globex): June 2021'},
        {name: 'GCEM21', change: 0.3, changePercent: 0.1, openPrice: 1777.2, closePrice: 17778.3, highPrice: 1778.9, lowPrice: 1777, time: 'Gold (Globex): June 2021'},
        {name: 'GCEM21', change: 0.9, changePercent: 0.1, openPrice: 1777.2, closePrice: 17778.3, highPrice: 1778.9, lowPrice: 1777, time: 'Gold (Globex): June 2021'},
        {name: 'GCEM21', change: 0.2, changePercent: 0.1, openPrice: 1777.2, closePrice: 17778.3, highPrice: 1778.9, lowPrice: 1777, time: 'Gold (Globex): June 2021'},
        {name: 'GCEM21', change: 0.3, changePercent: 0.1, openPrice: 1777.2, closePrice: 17778.3, highPrice: 1778.9, lowPrice: 1777, time: 'Gold (Globex): June 2021'},
        {name: 'GCEM21', change: 0.5, changePercent: 0.1, openPrice: 1777.2, closePrice: 17778.3, highPrice: 1778.9, lowPrice: 1777, time: 'Gold (Globex): June 2021'},
        {name: 'GCEM21', change: 0.1, changePercent: 0.1, openPrice: 1777.2, closePrice: 17778.3, highPrice: 1778.9, lowPrice: 1777, time: 'Gold (Globex): June 2021'},
        {name: 'GCEM21', change: 0.7, changePercent: 0.1, openPrice: 1777.2, closePrice: 17778.3, highPrice: 1778.9, lowPrice: 1777, time: 'Gold (Globex): June 2021'},
        {name: 'GCEM21', change: 0.4, changePercent: 0.1, openPrice: 1777.2, closePrice: 17778.3, highPrice: 1778.9, lowPrice: 1777, time: 'Gold (Globex): June 2021'},
        {name: 'GCEM21', change: 0.5, changePercent: 0.1, openPrice: 1777.2, closePrice: 17778.3, highPrice: 1778.9, lowPrice: 1777, time: 'Gold (Globex): June 2021'},
        {name: 'GCEM21', change: 0.5, changePercent: 0.1, openPrice: 1777.2, closePrice: 17778.3, highPrice: 1778.9, lowPrice: 1777, time: 'Gold (Globex): June 2021'},
        {name: 'GCEM21', change: 0.8, changePercent: 0.1, openPrice: 1777.2, closePrice: 17778.3, highPrice: 1778.9, lowPrice: 1777, time: 'Gold (Globex): June 2021'},
        {name: 'GCEM21', change: 0.3, changePercent: 0.1, openPrice: 1777.2, closePrice: 17778.3, highPrice: 1778.9, lowPrice: 1777, time: 'Gold (Globex): June 2021'},
        {name: 'GCEM21', change: 0.4, changePercent: 0.1, openPrice: 1777.2, closePrice: 17778.3, highPrice: 1778.9, lowPrice: 1777, time: 'Gold (Globex): June 2021'},
        {name: 'GCEM21', change: 0.5, changePercent: 0.1, openPrice: 1777.2, closePrice: 17778.3, highPrice: 1778.9, lowPrice: 1777, time: 'Gold (Globex): June 2021'},
        {name: 'GCEM21', change: 0.4, changePercent: 0.1, openPrice: 1777.2, closePrice: 17778.3, highPrice: 1778.9, lowPrice: 1777, time: 'Gold (Globex): June 2021'},
        ]);
    const [listImage, setListImage] = useState([]);
    const [filters, setFilters] = useState([]);
    const [filterId, setFilterId] = useState(-1);
    useEffect(() => {
        getData();
        let io = require('socket.io-client');
        let socket = io.connect('http://222.252.22.174:8087', { transports: ['websocket'], jsonp: false, reconnect: true });
        socket.on('response-update-price', (message) => {
            console.log('received message', message)
        });
    }, []);

    const onReceivedMessage = (message) => {
        console.log(message)
    }
    const getData = async () => {
        const res = await getTransaction({});
        if (res.data.code == 200 && res.data.data) {
            setData(res.data.data);
        } else {
            Alert.alert(I18n.t('Notification'), I18n.t('Can_not_get_data'));
        }

        const res1 = await getImagesHome({});
        if (res1.data.code == 200 && res1.data.data) {
            setListImage(res1.data.data);
        } else {
            Alert.alert(I18n.t('Notification'), I18n.t('Can_not_get_data'));
        }
        const resCategoryProduct = await getListCategoryProduct({
            keyword: '',
            platform: Platform.OS,
            page_size: 20,
            page_index: 1,
            type: 'PRODUCT',
        });
        console.log(resCategoryProduct)
        if ((resCategoryProduct.data.code = 200 && resCategoryProduct.data.data)) {
            let data = [];
            data.push({id: -1, name: 'All'});
            setFilters(data.concat([...resCategoryProduct.data.data]));
        } else {
            Alert.alert(I18n.t('Notification'), res.data.message);
        }
    };

    return <HomeView
        data={data}
        dataPrice={dataPrice}
        listImage={listImage}
        filterId={filterId}
        filters={filters}
        setFilterId={setFilterId}
    />;
};

const mapStateToProps = (state) => {
    return {
        user: state.userReducer,
    };
};
export default connect(mapStateToProps, {})(Home);
