import React from 'react';
import {View, Text, StyleSheet, TouchableOpacity, Image} from 'react-native';
import {
  getFontXD,
  HEIGHTXD,
  WIDTHXD,
  toPriceVnd,
  converType,
  converStatus,
} from '../../../Config/Functions';
import R from '../../../assets/R';
import Block from '../../../components/Block';
import {useNavigation} from '@react-navigation/native';
import {HISTORYDETAIL} from '../../../routers/ScreenNames';

const Item = (props) => {
  const {item} = props;
  console.log('item---', item);
  const navigate = useNavigation();
  return (
    <TouchableOpacity
      onPress={() =>
        navigate.navigate(HISTORYDETAIL, {id: item.transection_id})
      }
      style={styles.container}>
      <Block flex={1} row>
        <View style={styles.wrapDate}>
          <Image source={{uri: item.icon}} style={styles.imgIcon} />
        </View>
        <Block
          style={{justifyContent: 'center'}}
          padding={[5, 10]}
          space={'between'}
          flex={1}>
          <View
            style={{
              flexDirection: 'row',
              justifyContent: 'space-between',
            }}>
            <View
              style={{
                alignItems: 'flex-start',
              }}>
              <Text style={styles.txtBlack}>{item.name}</Text>
              <Text style={styles.txt}>{item.transection_date_timestamp}</Text>
            </View>

            <View style={{alignItems: 'flex-end'}}>
              <Text
                style={[
                  styles.txtMoney,
                  item.status == 1 ? {color: '#1473E6'} : null,
                ]}>
                {toPriceVnd(item.amount)} Đ
              </Text>
              <Text style={styles.txt}> {item.status_name}</Text>
            </View>
          </View>
        </Block>
      </Block>
    </TouchableOpacity>
  );
};

export default Item;

const styles = StyleSheet.create({
  container: {
    height: HEIGHTXD(250),
    shadowColor: '#000',
    shadowOffset: {
      width: 0,
      height: 2,
    },
    shadowOpacity: 0.25,
    shadowRadius: 3.84,
    elevation: 5,
    marginHorizontal: 10,
    backgroundColor: R.colors.white,
    marginVertical: 5,
    borderRadius: HEIGHTXD(30),
  },
  wrapRight: {
    borderLeftColor: R.colors.borderGray,
    borderLeftWidth: 0.7,
  },
  wrapLeft: {
    width: WIDTHXD(16),
    borderTopLeftRadius: HEIGHTXD(30),
    borderBottomStartRadius: HEIGHTXD(30),
  },
  wrapDate: {
    justifyContent: 'center',
    paddingLeft: 10,
  },
  txt: {
    fontSize: getFontXD(36),
    color: '#C4C4C4',
    marginTop: 10,
  },
  imgIcon: {
    width: WIDTHXD(178),
    height: HEIGHTXD(178),
    resizeMode: 'contain',
  },
  txtMoney: {
    fontSize: getFontXD(42),
    fontWeight: 'bold',
    color: '#F99D1D',
  },
  txtBlack: {
    fontSize: getFontXD(42),
  },
});
