import React, {useState} from 'react';
import {
  View,
  Text,
  TouchableOpacity,
  Image,
  StyleSheet,
  Alert,
  KeyboardAvoidingView,
  ScrollView,
  Platform,
  Dimensions,
  TouchableWithoutFeedback,
  Keyboard,
} from 'react-native';
import Button from '../../../components/Button';
import PickerImgUni from '../../../components/Picker/PickerImgUni';
import R from '../../../assets/R';
import TextField from '../../../components/Input/TextField';
import I18n from '../../../helper/i18/i18n';
import {connect} from 'react-redux';
import {showLoading, hideLoading} from '../../../actions/loadingAction';
import {
  checkFormatArray,
  getFontXD,
  convertTime,
  HEIGHTXD,
  WIDTHXD,
} from '../../../Config/Functions';
import PickerDate from '../../../components/Picker/PickerDate';

const {width} = Dimensions.get('window');

const Item = (props) => {
  return (
    <View style={styles.container}>
      <View style={{width: WIDTHXD(480), marginBottom: 5}}>
        <Text style={styles.txtTitle}>{props.title}:</Text>
      </View>

      <View style={{justifycontent: 'center', alignItems: 'center'}}>
        <Image style={styles.containerImg} source={{uri: props.linkImg}} />
      </View>
    </View>
  );
};

const Profile = (props) => {
  const renderType = (type) => {
    switch (type) {
      case 1:
        return I18n.t('IdentityCard');
      case 2:
        return I18n.t('Passport');
      default:
        return I18n.t('CitizenIdentification');
    }
  };
  return (
    <KeyboardAvoidingView
      behavior={Platform.Os === 'ios' ? 'padding' : 'height'}
      style={{flex: 1}}
      keyboardVerticalOffset={-50}>
      <TouchableWithoutFeedback onPress={Keyboard.dismiss}>
        <ScrollView style={{flex: 1}} showsVerticalScrollIndicator={false}>
          <View
            style={{
              flex: 1,
              paddingHorizontal: 10,
              paddingTop: 10,
            }}>
            <TextField
              value={renderType(props.user.card_type)}
              editable={false}
              title={I18n.t('CardType')}
            />

            <View
              style={{
                flexDirection: 'row',
                justifyContent: 'space-between',
                flexWrap: 'wrap',
                flex: 1,
              }}>
              <Item
                linkImg={props.user.identity_before}
                title={I18n.t('IdentityCitizenCardBackPhoto')}
              />
              <Item
                linkImg={props.user.identity_after}
                title={I18n.t('IdentityCitizenCardFrontPhoto')}
              />
              <Item linkImg={props.user.sign_img} title={I18n.t('SignPhoto')} />
            </View>
          </View>
        </ScrollView>
      </TouchableWithoutFeedback>
    </KeyboardAvoidingView>
  );
};

const styles = StyleSheet.create({
  container: {
    marginTop: 10,
    width: WIDTHXD(480),
    alignItems: 'center',
  },
  btnSend: {
    width: '100%',
    marginBottom: 10,
  },
  txtTitle: {
    fontSize: getFontXD(42),
    color: R.colors.color777,
    marginBottom: 5,
  },
  containerImg: {width: WIDTHXD(350), height: HEIGHTXD(320), borderRadius: 5},
});

const mapStateToProps = (state) => {
  return {
    user: state.userReducer,
  };
};
export default connect(mapStateToProps, {showLoading, hideLoading})(Profile);
