import React, {useEffect} from 'react';
import {
  View,
  Text,
  ImageBackground,
  StyleSheet,
  StatusBar,
  SafeAreaView,
} from 'react-native';

import {connect} from 'react-redux';
import StackNavigation from './routers/StackNavigation';
import Modal from 'react-native-modal';
import {SkypeIndicator} from 'react-native-indicators';
import {enableScreens} from 'react-native-screens';
import NoInternetComponent from './components/NoInternet';

import DeviceInfo from 'react-native-device-info';
import VersionChecker from './Screens/VersionChecker';
import DropDown from './components/DropDown';

enableScreens();

const RootView = (props) => {
  useEffect(() => {}, []);

  const checkVersion = (props) => {
    const verCurrent = DeviceInfo.getVersion();
    console.log('version current', verCurrent);
  };

  return (
    <>
      <View style={{flex: 1}}>
        <Modal isVisible={props.loadingModal.isVisible}>
          <SkypeIndicator color={'white'} />
        </Modal>
        <StackNavigation />
      </View>
      {/*<VersionChecker/>*/}
      {/* <DropDown /> */}

      <NoInternetComponent />
    </>
  );
};

const mapStateToProps = (state) => {
  return {
    loadingModal: state.ModalLoadingReducer,
  };
};

export default connect(mapStateToProps, {})(RootView);
