import React, {Component} from 'react';
import {StyleSheet, View, Image, Text, TouchableOpacity, SafeAreaView} from 'react-native';
import {
  WIDTHXD,
  HEIGHTXD,
  getFontXD,
  WIDTHXDICON,
} from '../../Config/Functions';
import R from '../../assets/R';
import Icon from 'react-native-vector-icons/AntDesign';
import MonthPicker, {ACTION_DATE_SET} from 'react-native-month-year-picker';

/**
 * This Function to choice date
 * @callback onValueChange value of date you choice
 * @param value value of date you choice
 * @param containerStyle custom containerStyle of view
 * @param textStyle style value of date
 * @param placeholder value of placeholder
 * @param width width of datePicker
 * @param date value of date you choice
 * @param enableEdit status allow edit
 * other you can make minDate,maxDate... with props of libary react-native-datepicker
 */
class PickerMonth extends Component {
  state = {
    date: new Date(),
    show: false,
  };

  render() {
    const {
      valueString,
      onValueChange,
      containerStyle,
      textStyle,
      width,
      title,
      date,
    } = this.props;
    return (
      <>
        <View style={{marginTop: HEIGHTXD(40)}}>
          <Text
            style={{
              fontSize: getFontXD(42),
              color: R.colors.color777,
              marginBottom: 5,
            }}>
            {title}
          </Text>
          <View
            style={[
              styles.inputBox,
              width && {width},
            ]}>
            <View
              style={{
                flexDirection: 'row',
                justifyContent: 'space-between',
                alignItems: 'center',
                flex: 1,
                paddingHorizontal: WIDTHXD(20),
              }}>
              <Text
                style={{
                  ...styles.textDate,
                  ...textStyle,
                  paddingVertical: 0,
                  marginRight: WIDTHXD(15),
                }}>
                {valueString}
              </Text>
              <TouchableOpacity onPress={() => this.setState({show: true})}>
                <Icon name={'calendar'} size={22} color={'#929292'}/>
              </TouchableOpacity>
            </View>
          </View>
        </View>
        {this.state.show && (
          <MonthPicker
            onChange={(event, newDate) => {
              this.setState({show: false});
              console.log(event, newDate)
              if (event == ACTION_DATE_SET) {
                onValueChange(event, newDate);
              }
            }}
            value={date}
            locale="vi"
          />
        )}
      </>
    );
  }
}

const styles = StyleSheet.create({
  inputBox: {
    borderRadius: WIDTHXD(20),

    height: HEIGHTXD(120),
    borderWidth: 0.3,
    borderColor: R.colors.borderGray,
    flexDirection: 'row',
    alignItems: 'center',
    justifyContent: 'center',
    // paddingVertical: HEIGHTXD(17),
    backgroundColor: 'white',
  },
  textDate: {
    fontSize: getFontXD(42),
    color: R.colors.black,
    alignSelf: 'flex-start',
  },
});

export default React.memo(PickerMonth);
