import React, {useState} from 'react';
import {DeviceEventEmitter, Platform, View} from 'react-native';
import {getFontXD} from '../../Config/Functions';
import DueDate from './DueDate/DueDate';
import Escrow from './Escrow/Escrow';
import PriceList from './PriceList/PriceList';
import TimeTransaction from './TimeTransaction/TimeTransaction';
import I18n from '../../helper/i18/i18n';
import {connect} from 'react-redux';

import {createMaterialTopTabNavigator} from '@react-navigation/material-top-tabs';
import HeaderDrawer from '../../components/Header/HeaderDrawer';
import SearchProductCodeModal from './SearchProductCodeModal';
import {getListCategoryProduct} from '../../apis/Functions/Transaction';
import {showAlert, TYPE} from '../../components/DropdownAlert';
import _ from 'lodash';

const Tab = createMaterialTopTabNavigator();

const NewFeed = (props) => {
  const [showSearchPopup, setShowSearchPopup] = useState(false);
  const [dataCategory, setDataCategory] = useState([]);


  const onSearchPress = () => {
    setShowSearchPopup(true);
    DeviceEventEmitter.emit('PressSearchTransaction')
    if (_.isEmpty(dataCategory)) {
      getCategoryData();
    }
  };
  const getCategoryData = async () => {
    // setIsRefresh(true);
    const res = await getListCategoryProduct({
      keyword: '',
      platform: Platform.OS,
      page_size: 20,
      page_index: 1,
      type: 'PRODUCT',
    });
    if ((res.data.code = 200 && res.data.data)) {
      let data = [];
      data.push({id: -1, name: I18n.t('All')});
      setDataCategory(data.concat([...res.data.data]));
    } else {
      showAlert(TYPE.ERROR, I18n.t('Notification'), res.data.message);
    }
  };

  const onSearch = (industryGroup, product, period) => {
    setShowSearchPopup(false);
    DeviceEventEmitter.emit('SearchTransaction', {industryGroup: industryGroup, product: product, period: period});
  };
  return (
    <View style={{flex: 1}}>
      <HeaderDrawer title={'Tradding'} isWhite={true} isShowSearch={true} onSearchPress={onSearchPress}/>
      <View style={{flex: 1, backgroundColor: 'white'}}>
          <Tab.Navigator
            initialRouteName="PriceList"
            swipeEnabled={false}
            tabBarOptions={{
              scrollEnabled: true,
              inactiveTintColor: '#929292',
              activeTintColor: '#1473E6',
              labelStyle: {fontSize: getFontXD(36)},
              style: {backgroundColor: 'white'},
            }}>
            <Tab.Screen
              name="PriceList"
              component={PriceList}
              options={{
                tabBarLabel:
                  props.language.language == 'vi' ? 'Bảng phí' : 'PriceList',
              }}
            />
            <Tab.Screen
              name="TimeTransaction"
              component={TimeTransaction}
              options={{
                tabBarLabel:
                  props.language.language == 'vi'
                    ? 'Thời gian GD'
                    : 'Time transace',
              }}
            />
            <Tab.Screen
              name="Escrow"
              component={Escrow}
              options={{
                tabBarLabel:
                  props.language.language == 'vi' ? 'Ký quỹ' : 'Escrow',
              }}
            />
            <Tab.Screen
              name="DueDate"
              component={DueDate}
              options={{
                tabBarLabel:
                  props.language.language == 'vi' ? 'Lịch đáo hạn' : 'Due date',
              }}
            />
          </Tab.Navigator>
      </View>
      <SearchProductCodeModal
        hidePopup={() => {
          setShowSearchPopup(false);
        }}
        isModalVisible={showSearchPopup}
        data={[]}
        dataCategory={dataCategory}
        onSearchPress={onSearch}
      />
    </View>
  );
};

const mapStateToProps = (state) => {
  return {
    language: state.languageReducer,
  };
};

export default connect(mapStateToProps, {})(NewFeed);
