import React, {useEffect, useState} from 'react';
import {
  View,
  Text,
  Image,
  StyleSheet,
  TouchableOpacity,
  TouchableWithoutFeedback, Platform, DeviceEventEmitter,
} from 'react-native';
import R from '../../assets/R';
import {HEIGHTXD, WIDTHXD, getFontXD, getWidth} from '../../Config/Functions';
import Modal from 'react-native-modal';
import I18n from '../../helper/i18/i18n';
import AppText from '../../components/AppText';
import PickerItem from '../../components/Picker/PickerItem';
import PickerMonth from '../../components/Picker/PickerMonth';
import {getTransactionListByCategory} from '../../apis/Functions/Transaction';
import {showAlert, TYPE} from '../../components/DropdownAlert';
import _ from 'lodash';
import {TRANSACTION_TYPE} from '../../Config/constants';
import moment from 'moment';
import IconClose from 'react-native-vector-icons/AntDesign';

const SearchProductCodeModal = (props) => {
  const [isModalVisible, setModalVisible] = useState(props.isModalVisible);
  const [industryGroup, setIndustryGroup] = useState({id: -1, name: I18n.t('All')});
  const [product, setProduct] = useState(null);
  const [period, setPeriod] = useState(new Date());
  const [dataProduct, setDataProduct] = useState([]);
  const [dataProductFilter, setDataProductFilter] = useState([]);

  useEffect(() => {
    let clearSearch = DeviceEventEmitter.addListener('ClearSearch', (params) => {
      setProduct(null)
      setPeriod(new Date())
      setIndustryGroup({id: -1, name: I18n.t('All')})
    });
    return () => {
      clearSearch.remove();
    };
  })

  const getDataProduct = async () => {
    if (_.isEmpty(dataProduct)) {
      const res = await getTransactionListByCategory({
        keyword: '',
        platform: Platform.OS,
        page_size: 100,
        page_index: 1,
        type: TRANSACTION_TYPE.PRODUCT,
        category_id: -1,
      });
      if ((res.data.code = 200 && res.data.data)) {
        setDataProduct(res.data.data);
      } else {
        showAlert(TYPE.ERROR, I18n.t('Notification'), res.data.message);
      }
    }
    let data = [];
    data.push({id: -1, name: I18n.t('All')});
    let newDataProduct = industryGroup.id == -1 ? [...dataProduct] : _.filter(dataProduct, (item) => item.category_id == industryGroup.id);
    setDataProductFilter(data.concat(newDataProduct));
  };

  useEffect(() => {
    let newDataProduct = industryGroup.id == -1 ? [...dataProduct] : _.filter(dataProduct, (item) => item.category_id == industryGroup.id);
    let data = [];
    data.push({id: -1, name: I18n.t('All')});
    setDataProductFilter(data.concat(newDataProduct));
  }, [dataProduct]);
  useEffect(() => {
    setDataProductFilter([]);
    setProduct(null);
    getDataProduct();
  }, [industryGroup]);
  useEffect(() => {
    setModalVisible(props.isModalVisible);
    if (props.isModalVisible && _.isEmpty(dataProduct)) {
      getDataProduct();
    }
  }, [props.isModalVisible]);
  return (
    <Modal
      isVisible={isModalVisible}
      style={{margin: 0, justifyContent: 'flex-end'}}>
      <View style={{flex: 1, justifyContent: 'flex-end'}}>
        <TouchableOpacity
          style={styles.opacity}
          activeOpacity={1}
          onPressOut={() => {
            props.hidePopup()
          }}
        >
          <TouchableWithoutFeedback>
            <View style={styles.container}>
              <View style={styles.viewTitle}>
                <Text style={[styles.txt, {
                  color: R.colors.black,
                  textAlign: 'center',
                  flex: 10,
                }]}>{I18n.t('SearchProductCode')}</Text>
                <TouchableOpacity onPress={() => {
                  props.hidePopup();
                }} style={styles.btClose}>
                  <IconClose name='close' size={WIDTHXD(48)} color={R.colors.black}/>
                </TouchableOpacity>
              </View>
              <AppText style={[styles.txtTitle, {marginTop: HEIGHTXD(40)}]} i18nKey={'IndustryGroup'}/>
              <PickerItem
                width={getWidth() - WIDTHXD(80)}
                data={props.dataCategory}
                defaultValue={industryGroup.name}
                onValueChange={(value, item) => {
                  setIndustryGroup(item);
                }}
              />
              <AppText style={[styles.txtTitle, {marginTop: HEIGHTXD(40)}]} i18nKey={'Product'}/>
              <PickerItem
                width={getWidth() - WIDTHXD(80)}
                defaultValue={product ? product.name : ''}
                data={dataProductFilter}
                onValueChange={(value, item) => {
                  setProduct(item);
                }}
              />

              <PickerMonth
                valueString={moment(period).format('MM/YYYY')}
                title={I18n.t('Period')}
                isMonthYearPicker={true}
                showSelectMonth={props.showSelectMonth}
                date={period}
                containerStyle={{marginTop: HEIGHTXD(40)}}
                onValueChange={(e, value) => {
                  setPeriod(value);
                }}
              />

              <View
                style={{
                  marginTop: HEIGHTXD(80),
                  justifyContent: 'center',
                  alignItems: 'center',
                }}>
                <TouchableOpacity onPress={() => {
                  props.onSearchPress(industryGroup, product, period);
                }} style={styles.btnSend}>
                  <Text style={styles.txtSend}>{I18n.t('Search')}</Text>
                </TouchableOpacity>
              </View>
            </View>
          </TouchableWithoutFeedback>
        </TouchableOpacity>
      </View>
    </Modal>
  );
};

const styles = StyleSheet.create({
  container: {
    backgroundColor: R.colors.white,
    borderRadius: 10,
    borderWidth: 2,
    borderColor: '#DBDBDB',
    paddingTop: HEIGHTXD(50),
    paddingBottom: HEIGHTXD(300),
    paddingHorizontal: WIDTHXD(40),
  },
  viewTitle: {
    flexDirection: 'row',
    width: getWidth() - WIDTHXD(40),
    marginLeft: WIDTHXD(40),
  },
  btClose: {
    flex: 1,
    justifyContent: 'center',
    alignItems: 'flex-start',
    marginRight: WIDTHXD(40),
  },
  txt: {
    fontSize: getFontXD(42),
    color: R.colors.color777,
    marginBottom: 5,
    paddingLeft: 10,
  },
  txtTitle: {
    fontSize: getFontXD(42),
    color: R.colors.color777,
  },
  selectionImg: {
    padding: 10,
    justifyContent: 'center',
    alignItems: 'center',
  },
  containerSelect: {
    height: HEIGHTXD(520),
    backgroundColor: 'white',
    paddingTop: 10,
    borderTopLeftRadius: 20,
    borderTopRightRadius: 20,
  },
  line: {
    height: 1,
    backgroundColor: '#929292',
    width: '100%',
    marginTop: 5,
  },
  imgIcon: {
    width: 40,
    height: 40,
  },
  txtTitleBtn: {
    fontSize: getFontXD(42),
    color: '#1473E6',
  },
  btnSend: {
    width: WIDTHXD(500),
    height: HEIGHTXD(120),
    backgroundColor: R.colors.main,
    borderRadius: 8,
    justifyContent: 'center',
    alignItems: 'center',
  },
  txtSend: {
    fontSize: getFontXD(42),
    color: R.colors.white,
    paddingHorizontal: WIDTHXD(60),
    fontWeight: 'bold',
  },
});

export default SearchProductCodeModal;
