import React, {useState, useEffect} from 'react';
import {getListNotification} from '../../../apis/Functions/users';
import DueDateView from './DueDateView';
import I18n from '../../../helper/i18/i18n';
import {
  getListCategoryProduct,
  getTransactionListByCategory,
} from '../../../apis/Functions/Transaction';
import {Alert, DeviceEventEmitter, Platform} from 'react-native';
import PriceListView from '../PriceList/PriceListView';
import {showAlert, TYPE} from '../../../components/DropdownAlert';
import moment from 'moment';
import {useNavigation} from '@react-navigation/native';

const DueDate = (props) => {
  const [page, setPage] = useState(1);
  const [data, setData] = useState([]);
  const [tottalPage, setTotalPage] = useState(1);
  const [isRefresh, setIsRefresh] = useState(false);
  const [filters, setFilters] = useState([]);
  const [filterId, setFilterId] = useState(-1);
  const [productId, setProductId] = useState(null);
  const [period, setPeriod] = useState(null);
  const navigation = useNavigation();

  useEffect(() => {
    getCategoryData();
    let pressSearchListener = DeviceEventEmitter.addListener('PressSearchTransaction', (params) => {
      navigation.jumpTo('DueDate');
    });
    let searchListener = DeviceEventEmitter.addListener('SearchTransaction', (params) => {
      console.log('get data', params)
      setFilterId(params.industryGroup.id);
      if (params.product && params.product != -1) {
        setProductId(params.product.id);
      } else {
        setProductId(null);
      }
      if (params.period) {
        setPeriod(moment(params.period).format('MM/YYYY'));
      } else {
        setPeriod(null)
      }

    });
    return () => {
      pressSearchListener.remove();
      searchListener.remove();
    };
  }, []);
  useEffect(() => {
    setData([]);
    getData();
  }, [filterId, productId, period]);

  const getCategoryData = async () => {
    // setIsRefresh(true);
    const res = await getListCategoryProduct({
      keyword: '',
      platform: Platform.OS,
      page_size: 20,
      page_index: 1,
      type: 'PRODUCT',
    });
    if ((res.data.code = 200 && res.data.data)) {
      let data = [];
      data.push({id: -1, name: 'All'});
      setFilters(data.concat([...res.data.data]));
    } else {
      showAlert(TYPE.ERROR, I18n.t('Notification'), res.data.message);
    }
  };

  const onRefresh = () => {
    setPage(1);
    setProductId(null)
    setPeriod(null)
    getData();
    DeviceEventEmitter.emit('ClearSearch')
  };

  const getData = async () => {
    setIsRefresh(true);
    setPage(1);
    let body = {
      keyword: '',
      platform: Platform.OS,
      page_size: 10,
      page_index: 1,
      type: 'EXPIRY_DATE',
      category_id: filterId,
    }
    if(productId) body.commoditiy_id = productId
    if(period) body.term = period
    const res = await getTransactionListByCategory(body);
    setIsRefresh(false);
    console.log('getData', res);
    if ((res.data.code = 200 && res.data.data)) {
      setData(res.data.data);
      setTotalPage(res.data.meta.pages);
    } else {
      showAlert(TYPE.ERROR, I18n.t('Notification'), res.data.message);
    }
  };

  const onLoadMore = () => {
    console.log(tottalPage);
    if (page < tottalPage) {
      getDataLoadMore();
    }
  };

  const getDataLoadMore = async () => {
    setIsRefresh(true);
    let body = {
      keyword: '',
      platform: Platform.OS,
      page_size: 10,
      page_index: page + 1,
      type: 'EXPIRY_DATE',
      category_id: filterId,
    }
    if(productId) body.commoditiy_id = productId
    if(period) body.term = period
    const res = await getTransactionListByCategory(body);
    setPage(page + 1);
    if (res.data.code == 200) {
      setData(data.concat(res.data.data));
    }
    setIsRefresh(false);
  };

  return (
    <DueDateView
      onRefresh={onRefresh}
      isRefresh={isRefresh}
      onLoadMore={onLoadMore}
      setFilterId={setFilterId}
      filterId={filterId}
      filters={filters}
      data={data}
    />
  );
};

export default DueDate;
