import React, {Component, useState, useEffect} from 'react';
import {
  View,
  Text,
  StyleSheet,
  TextInput,
  TouchableOpacity,
  Dimensions,
} from 'react-native';
import HeaderBack from '../../components/Header/HeaderBack';
const {width} = Dimensions.get('window');
import PickerItem from '../../components/Picker/PickerItem';
import I18n from '../../helper/i18/i18n';
import AppText from '../../components/AppText';
import TextField from '../../components/Input/TextField';
import {getFontXD, HEIGHTXD, toPriceVnd, WIDTHXD} from '../../Config/Functions';
import R from '../../assets/R';
import {showAlert, TYPE} from '../../components/DropdownAlert';
import {getListExchangeRate} from '../../apis/Functions/Transaction';
import {showLoading, hideLoading} from '../../actions/loadingAction';
import {connect} from 'react-redux';

const ExchangeRate = (props) => {
  const [product, setProduct] = useState();
  const [priceExchange, setPriceExchange] = useState();
  const [usdTan, setUsdTan] = useState();

  const [dataProduct, setDataProduct] = useState([]);
  useEffect(() => {
    getProductData();
  }, []);

  const getProductData = async () => {
    props.showLoading();
    const res = await getListExchangeRate({
      platform: Platform.OS,
      page_size: 1000,
      page_index: 1,
    });
    props.hideLoading();
    if (res.status == 200 && res.data.code == 200) {
      setDataProduct(res.data.data);
    } else {
      showAlert(TYPE.ERROR, I18n.t('Notification'), I18n.t('Can_not_get_data'));
    }
  };

  useEffect(() => {
    caculator();
  }, [product, priceExchange]);

  const caculator = () => {
    if (product && priceExchange) {
      const total = priceExchange * product.exchange_rate;
      setUsdTan(total + '');
    } else if (!priceExchange) setUsdTan('');
  };

  const onClick = () => {
    setPriceExchange('');
    setUsdTan('');
  };

  return (
    <View style={{flex: 1}}>
      <HeaderBack title={'ExchangeRate'} />
      <View style={{flex: 1, paddingTop: 10, paddingHorizontal: 10}}>
        <AppText style={styles.txtTitle} i18nKey={'Product'} />
        <PickerItem
          width={width - 20}
          data={dataProduct}
          onValueChange={(value, items) => {
            setProduct(items);
          }}
        />
        <TextField
          value={'US cent/ giạ'}
          editable={true}
          title={I18n.t('UnitsQuotedFloor')}
        />
        <TextField
          isNumber={true}
          maxLength={12}
          value={priceExchange}
          onChangeText={(val) => setPriceExchange(val)}
          title={I18n.t('ConversionPrice')}
        />
        <TextField
          value={usdTan}
          editable={true}
          title={I18n.t('ConvertUSD')}
        />
        <View style={styles.footer}>
          <TouchableOpacity onPress={onClick} style={styles.btnContainer}>
            <AppText style={styles.txtBtn} i18nKey={'Delete'} />
          </TouchableOpacity>
        </View>
      </View>
    </View>
  );
};

const styles = StyleSheet.create({
  txtTitle: {
    fontSize: getFontXD(42),
    color: R.colors.color777,
    marginTop: 15,
  },
  note: {
    fontSize: getFontXD(36),
    fontStyle: 'italic',
    marginTop: 10,
  },
  row: {
    height: HEIGHTXD(109),
    width: '80%',
    justifyContent: 'space-between',
    marginVertical: 5,
    paddingHorizontal: 10,
  },
  footer: {
    alignItems: 'center',
    justifyContent: 'center',
    marginTop: 30,
  },
  btnContainer: {
    width: WIDTHXD(428),
    height: HEIGHTXD(120),
    justifyContent: 'center',
    alignItems: 'center',
    backgroundColor: R.colors.red2,
    borderRadius: 10,
  },
  txtBtn: {
    fontSize: getFontXD(48),
    color: R.colors.white,
    fontWeight: '600',
  },
  wrapInput: {
    width: WIDTHXD(431),
    backgroundColor: R.colors.white,
    height: HEIGHTXD(109),
    fontSize: getFontXD(42),
    borderRadius: 5,
    paddingHorizontal: 10,
    shadowColor: '#000',
    shadowOffset: {
      width: 0,
      height: 1,
    },
    shadowOpacity: 0.2,
    shadowRadius: 1.41,
    elevation: 2,
  },
  wrap: {
    flexDirection: 'row',
    alignItems: 'center',
    justifyContent: 'space-between',
  },
  Item: {
    marginBottom: 20,
  },
  txtNote: {
    fontSize: getFontXD(36),
    textAlign: 'right',
    marginTop: 10,
  },
});

const mapStateToProps = (state) => {
  return {
    user: state.userReducer,
  };
};
export default connect(mapStateToProps, {showLoading, hideLoading})(
  ExchangeRate,
);
