import React from 'react';
import {
  StyleSheet,
  Text,
  TouchableOpacity,
  View,
  Dimensions,
} from 'react-native';
import I18n from '../../../helper/i18/i18n';
import PickerItem from '../../../components/Picker/PickerItem';
import {
  getFontXD,
  HEIGHTXD,
  toPriceVnd,
  WIDTHXD,
} from '../../../Config/Functions';
import R from '../../../assets/R';
import TextMoney from '../../../components/Input/InputMoney';
import Icon from 'react-native-vector-icons/Entypo';

const {width} = Dimensions.get('window');

const ItemEscrowCalculator = (props) => {
  return (
    <View style={styles.viewInput}>
      <View style={{flexDirection: 'row', flex: 1}}>
        <View style={{flex: 1, marginVertical: 5}}>
          <Text style={styles.textTitle}>{I18n.t('Product')}</Text>
          <PickerItem
            data={props.dataProduct}
            onValueChange={(value, item) => {
              props.setProduct(item);
            }}
            width={width / 2 - 30}
            iconSize={WIDTHXD(40)}
            iconColor={R.colors.black}
          />
        </View>
        <View style={{width: 20}} />
        <View style={{flex: 1}}>
          <TextMoney
            onChangeText={(val) => {
              props.setLotNumber(val);
            }}
            title={I18n.t('LotTransactionNumber')}
            value={toPriceVnd(props.item.lotNumber)}
            titleStyle={{fontSize: getFontXD(39)}}
          />
        </View>
      </View>

      <TextMoney
        onChangeText={(val) => {}}
        title={I18n.t('FirstEscrow')}
        value={props.item.firstEscrow}
        titleStyle={{ontSize: getFontXD(39)}}
        editable={false}
        inputStyle={{backgroundColor: R.colors.gray7}}
      />
    </View>
  );
};
const styles = StyleSheet.create({
  viewInput: {
    marginHorizontal: WIDTHXD(36),
    marginBottom: WIDTHXD(30),
    borderWidth: 0.3,
    borderColor: '#707070',
    paddingHorizontal: WIDTHXD(24),
    paddingVertical: WIDTHXD(24),
    
  },
  textTitle: {
    fontSize: getFontXD(39),
    color: R.colors.color777,
  },
});
export default ItemEscrowCalculator;
