import React from 'react';
import {
  FlatList,
  StyleSheet,
  Text,
  TouchableOpacity,
  View,
  ScrollView,
} from 'react-native';
import HeaderBack from '../../../components/Header/HeaderBack';
import {
  getFontXD,
  HEIGHTXD,
  toPriceVnd,
  WIDTHXD,
} from '../../../Config/Functions';
import R from '../../../assets/R';
import I18n from '../../../helper/i18/i18n';
import TextMoney from '../../../components/Input/InputMoney';
import Icon from 'react-native-vector-icons/Entypo';
import ItemEscrowCalculator from './ItemEscrowCalculator';

const EscrowCalculatorView = (props) => {
  return (
    <View style={{flex: 1, flexDirection: 'column', backgroundColor: 'white'}}>
      <HeaderBack title={'EscrowCalculator'} isWhite={true} />
      <ScrollView style={{paddingVertical: HEIGHTXD(60)}}>
        <View>
          <FlatList
            keyExtractor={(item) => item.id}
            data={props.listInput}
            renderItem={({item, index}) => (
              <ItemEscrowCalculator
                item={item}
                dataProduct={props.dataProduct}
                setProduct={(product) => {
                  item.product = product;
                  item.firstEscrow =
                    parseFloat(item.lotNumber) * product.escrow;
                  props.setItemInput(item, index);
                }}
                setLotNumber={(lotNumber) => {
                  item.lotNumber = lotNumber.split('.').join('');
                  item.firstEscrow = item.product
                    ? parseFloat(item.lotNumber) * item.product.escrow
                    : 0;
                  props.setItemInput(item, index);
                }}
              />
            )}
          />
          <View style={{flexDirection: 'row', justifyContent: 'flex-end'}}>
            <TouchableOpacity
              onPress={() => {
                props.onAdd();
              }}
              style={styles.containerBtn}>
              <Icon name={'plus'} size={27} color={R.colors.white} />
            </TouchableOpacity>
          </View>
          <View style={{paddingHorizontal: WIDTHXD(60)}}>
            <TextMoney
              editable={false}
              title={I18n.t('FirstEscrowTotal')}
              value={props.firstEscrowTotal}
              titleStyle={{
                marginTop: HEIGHTXD(160),
                fontSize: getFontXD(39),
              }}
              inputStyle={{backgroundColor: R.colors.gray7}}
            />

            <TextMoney
              onChangeText={(val) => {
                props.setFirstEscrow(val.split('.').join(''));
              }}
              title={I18n.t('AvailableMargin')}
              value={props.firstEscrow}
              titleStyle={{
                fontSize: getFontXD(39),
              }}
            />
            <Text style={styles.textMessage}>{props.message}</Text>
          </View>

          <View
            style={{
              width: '100%',
              flexDirection: 'row',
              justifyContent: 'center',
              alignItems: 'center',
              marginTop: HEIGHTXD(80),
              marginBottom: HEIGHTXD(150),
            }}>
            <TouchableOpacity
              onPress={() => {
                props.onDelete();
              }}
              style={[
                styles.btn,
                {backgroundColor: R.colors.red2, marginRight: WIDTHXD(72)},
              ]}>
              <Text style={styles.txtButton}>{I18n.t('Delete')}</Text>
            </TouchableOpacity>
            <TouchableOpacity
              onPress={() => {
                props.onCalculator();
              }}
              style={styles.btn}>
              <Text style={styles.txtButton}>{I18n.t('Calculator')}</Text>
            </TouchableOpacity>
          </View>
        </View>
      </ScrollView>
    </View>
  );
};
export default EscrowCalculatorView;
const styles = StyleSheet.create({
  viewInput: {
    marginHorizontal: WIDTHXD(36),
    marginTop: WIDTHXD(69),
    marginBottom: WIDTHXD(44),
    borderWidth: 0.3,
    borderColor: '#707070',
    paddingHorizontal: WIDTHXD(24),
    paddingVertical: WIDTHXD(24),
  },
  textTitle: {
    fontSize: getFontXD(39),
    color: R.colors.color777,
  },
  textMessage: {
    fontSize: getFontXD(39),
    color: R.colors.black,
    marginTop: HEIGHTXD(68),
  },
  containerBtn: {
    marginHorizontal: WIDTHXD(36),
    backgroundColor: R.colors.main,
    width: WIDTHXD(144),
    height: WIDTHXD(144),
    justifyContent: 'center',
    alignItems: 'center',
    shadowColor: '#000',
    shadowOffset: {
      width: 0,
      height: 2,
    },
    shadowOpacity: 0.25,
    shadowRadius: 3.84,
    elevation: 3,
    borderRadius: WIDTHXD(144),
  },
  btn: {
    width: WIDTHXD(428),
    height: HEIGHTXD(120),
    justifyContent: 'center',
    alignItems: 'center',
    backgroundColor: R.colors.main,
    borderRadius: 5,
    marginBottom: HEIGHTXD(42),
  },
  txtButton: {
    color: R.colors.white,
    fontSize: getFontXD(48),
  },
});
