import React, {useEffect, useState} from 'react';
import EscrowCalculatorView from './EscrowCalculatorView';
import {getTransactionListByCategory} from '../../../apis/Functions/Transaction';
import {Platform} from 'react-native';
import {showAlert, TYPE} from '../../../components/DropdownAlert';
import I18n from '../../../helper/i18/i18n';

const EscrowCalculator = (props) => {
    const [dataProduct, setDataProduct] = useState([]);
    const [listInput, setListInput] = useState([{
        product: null,
        lotNumber: null,
        firstEscrow: 0,
    }]);
    const [firstEscrow, setFirstEscrow] = useState(0);
    const [firstEscrowTotal, setFirstEscrowTotal] = useState(0);
    const [message, setMessage] = useState('');
    useEffect(() => {
        getProductData();
    }, []);

    const getProductData = async () => {
        const res = await getTransactionListByCategory({
            keyword: '',
            platform: Platform.OS,
            page_size: 1000,
            page_index: 1,
            type: 'PRICE_TABLE',
            category_id: -1,
        });
        console.log('res', res);

        if (res.status == 200 && res.data.code == 200) {
            setDataProduct(res.data.data);
        } else {
            showAlert(TYPE.ERROR, I18n.t('Notification'), I18n.t('Can_not_get_data'));
        }
    };

    const onCalculator = () => {
        if(firstEscrowTotal === '' || firstEscrowTotal == 0) {
            showAlert(TYPE.WARN, I18n.t('Notification'), I18n.t('EnterContractInfo'));
            return
        }

        if(firstEscrow === '' || firstEscrow == 0) {
            showAlert(TYPE.WARN, I18n.t('Notification'), I18n.t('EnterFirstEscrow'));
            return
        }

        if (parseFloat(firstEscrowTotal) <= parseFloat(firstEscrow)) {
            setMessage(I18n.t('YouCanTransaction'));
        } else {
            setMessage(I18n.t('YouCanNotTransaction'));
        }
    };

    const onDelete = () => {
        setListInput([{
            product: null,
            lotNumber: null,
            firstEscrow: 0,
        }])
        setFirstEscrow(0)
        setFirstEscrowTotal(0)
        setMessage('')
    };

    const setItemInput = (item, index) => {
        let data = [...listInput];
        data[index] = item;
        setListInput(data);
        let firstEscrowTotalTmp = 0;
        data.map((item) => {
            if (item.firstEscrow) {
                firstEscrowTotalTmp = firstEscrowTotalTmp + item.firstEscrow;
            }
        });
        setFirstEscrowTotal(firstEscrowTotalTmp);
    };
    const onAdd = () => {
        let data = [...listInput];
        data.push({
            product: null,
            lotNumber: null,
            firstEscrow: null,
        });
        setListInput(data);
    };

    return (
        <EscrowCalculatorView
            dataProduct={dataProduct}
            firstEscrow={firstEscrow}
            onCalculator={onCalculator}
            onDelete={onDelete}
            onAdd={onAdd}
            listInput={listInput}
            firstEscrowTotal={firstEscrowTotal}
            setItemInput={setItemInput}
            setFirstEscrow={setFirstEscrow}
            message={message}
        />
    );
};
export default EscrowCalculator;
