import React, {Component, useEffect, useState} from 'react';
import {
  View,
  Text,
  Dimensions,
  StyleSheet,
  TouchableOpacity,
  KeyboardAvoidingView,
  TouchableWithoutFeedback,
  ScrollView,
  Keyboard,
  Platform,
} from 'react-native';
import HeaderBack from '../../components/Header/HeaderBack';
import PickerItem from '../../components/Picker/PickerItem';
import I18n from '../../helper/i18/i18n';
import AppText from '../../components/AppText';
import TextField from '../../components/Input/TextField';
import {getFontXD, HEIGHTXD, WIDTHXD} from '../../Config/Functions';
import R from '../../assets/R';
import RadioForm, {
  RadioButton,
  RadioButtonInput,
  RadioButtonLabel,
} from 'react-native-simple-radio-button';

import {showAlert, TYPE} from '../../components/DropdownAlert';
import {getTransactionListByCategory} from '../../apis/Functions/Transaction';

var radio_props = [
  {label: 'Mua', value: 'BUY'},
  {label: 'Bán', value: 'SALE'},
];

const dataType = [
  {
    value: '0',
    name: 'Ngô mini',
  },
  {
    value: '1',
    name: 'Đỗ mini',
  },
];

const {width} = Dimensions.get('window');

const CaculatedStopLoss = (props) => {
  const [dataProduct, setDataProduct] = useState([]);

  const [product, setProduct] = useState();
  const [type, setType] = useState('BUY');
  const [lot, setLot] = useState(0);
  const [priceOpen, setPriceOpen] = useState(0);
  const [fee, setFee] = useState(0);
  const [surplus, setSurplus] = useState(0);

  const [inSession, setInSession] = useState(0);
  const [priceClose, setPriceClose] = useState(0);
  const [priceSopLoss, setPriceSopLoss] = useState(0);

  const onClick = () => {
    console.log('hello');
  };

  useEffect(() => {
    getProductData();
  }, []);

  const getProductData = async () => {
    const res = await getTransactionListByCategory({
      keyword: '',
      platform: Platform.OS,
      page_size: 1000,
      page_index: 1,
      type: 'PRICE_TABLE',
      category_id: -1,
    });
    if (res.status == 200 && res.data.code == 200) {
      setDataProduct(res.data.data);
    } else {
      showAlert(TYPE.ERROR, I18n.t('Notification'), I18n.t('Can_not_get_data'));
    }
  };

  return (
    <View style={{flex: 1}}>
      <HeaderBack title={'CaculatedStopLoss'} />
      <KeyboardAvoidingView
        behavior={Platform.Os === 'ios' ? 'padding' : 'height'}
        style={{flex: 1}}
        keyboardVerticalOffset={-50}>
        <TouchableWithoutFeedback onPress={Keyboard.dismiss}>
          <ScrollView showsVerticalScrollIndicator={false}>
            <View style={{flex: 1, paddingHorizontal: 10, paddingTop: 5}}>
              <AppText style={styles.txtTitle} i18nKey={'Product'} />
              <PickerItem
                width={width - 20}
                data={dataProduct}
                onValueChange={(value, items) => {
                  setProduct(items);
                }}
              />
              <AppText style={styles.txtTitle} i18nKey={'Tradding'} />
              <RadioForm
                formHorizontal={true}
                labelHorizontal={true}
                radio_props={radio_props}
                style={styles.row}
                initial={0}
                onPress={(value) => {
                  setType(value);
                }}
              />
              <TextField
                onChangeText={(val) => setLot(val)}
                isNumber={true}
                title={I18n.t('CountLotTradding')}
              />
              <TextField
                onChangeText={(val) => setPriceOpen(val)}
                isNumber={true}
                title={I18n.t('PriceOpen')}
              />
              <TextField
                onChangeText={(val) => setFee(val)}
                isNumber={true}
                title={I18n.t('FeeTradding')}
              />
              <TextField
                onChangeText={(val) => setSurplus(val)}
                isNumber={true}
                title={I18n.t('SurpusInit')}
              />
              <TextField
                onChangeText={(val) => setInSession(val)}
                isNumber={true}
                title={I18n.t('withdrawalsSession')}
              />
              <TextField
                onChangeText={(val) => setPriceClose(val)}
                isNumber={true}
                title={I18n.t('PriceClose')}
              />
              <TextField
                onChangeText={(val) => setPriceSopLoss(val)}
                isNumber={true}
                title={I18n.t('PriceStopLoss')}
              />
              <AppText style={styles.note} i18nKey={'noteStopLoss'} />
              <View style={styles.footer}>
                <TouchableOpacity onPress={onClick} style={styles.btnContainer}>
                  <AppText style={styles.txtBtn} i18nKey={'Caculate'} />
                </TouchableOpacity>
              </View>
            </View>
          </ScrollView>
        </TouchableWithoutFeedback>
      </KeyboardAvoidingView>
    </View>
  );
};

const styles = StyleSheet.create({
  txtTitle: {
    fontSize: getFontXD(42),
    color: R.colors.color777,
    marginTop: 15,
  },
  note: {
    fontSize: getFontXD(36),
    fontStyle: 'italic',
    marginTop: 10,
  },
  row: {
    height: HEIGHTXD(109),
    width: '80%',
    justifyContent: 'space-between',
    marginVertical: 5,
    paddingHorizontal: 10,
  },
  footer: {
    alignItems: 'center',
    justifyContent: 'center',
    marginTop: 20,
  },
  btnContainer: {
    width: WIDTHXD(428),
    height: HEIGHTXD(120),
    justifyContent: 'center',
    alignItems: 'center',
    backgroundColor: R.colors.main,
    borderRadius: 10,
  },
  txtBtn: {
    fontSize: getFontXD(48),
    color: R.colors.white,
    fontWeight: '600',
  },
});

export default CaculatedStopLoss;
