import React from 'react';
import {StyleSheet, Text, TouchableOpacity, View} from 'react-native';
import HeaderBack from '../../components/Header/HeaderBack';
import I18n from '../../helper/i18/i18n';
import {getFontXD, getWidth, HEIGHTXD, WIDTHXD} from '../../Config/Functions';
import R from '../../assets/R';
import * as Progress from 'react-native-progress';
import CountDown from '../../components/CountDown';


const SmartOTPView = (props) => {
    return <View style={{flex: 1}}>
        <HeaderBack title={'SmartOTP'}/>
        <View style={styles.viewOTP}>
            <Progress.Bar progress={props.progress}
                          width={getWidth() - HEIGHTXD(160)}
                          height={HEIGHTXD(15)}
                          color={R.colors.main}
                          backgroundColor={R.colors.white}
                          borderWidth={0}
                          borderRadius={10}
            />
            <Text style={{marginTop: HEIGHTXD(40)}}>
                <Text style={[styles.textNormal]}>
                    {I18n.t('OTPWillAutoUpdate')}
                </Text>
                <CountDown isReset={props.isReset} isFromSmartOTP={true} autoRefress={() => props.getNewOTP() } updateProgress={(count) => {props.updateProgress(count)}}/>
            </Text>
            <Text style={styles.textOTP}>
                {props.value}
            </Text>
            <Text style={[styles.textNormal, {
                width: '100%',
                backgroundColor: R.colors.colorOrangeLight,
                paddingVertical: HEIGHTXD(30),
                color: R.colors.brown,
            }]}>
                {I18n.t('SmartOTPWarning')}
            </Text>
        </View>

        {/*<View style={{*/}
        {/*    flexDirection: 'row',*/}
        {/*    marginHorizontal: HEIGHTXD(40),*/}
        {/*}}>*/}
        {/*    <Text style={[styles.textNormal, {*/}
        {/*        color: R.colors.main,*/}
        {/*    }]}>*/}
        {/*        Serial: 5324535436456576*/}
        {/*    </Text>*/}
        {/*    <Text style={[styles.textNormal, {*/}
        {/*        color: R.colors.main, position: 'absolute',*/}
        {/*        right: HEIGHTXD(0),*/}
        {/*    }]}>*/}
        {/*        {props.time}*/}
        {/*    </Text>*/}

        {/*</View>*/}

        <View style={{
            marginHorizontal: HEIGHTXD(40),
            marginVertical: HEIGHTXD(40),
        }}>
            <Text style={[styles.textNormal, {textAlign: 'left'}]}>{I18n.t('SmartOTPUsingFor')}</Text>
            <Text style={[styles.textNormal, {
                textAlign: 'left',
                marginTop: HEIGHTXD(20),
            }]}>{I18n.t('SmartOTPUsingForFirst')}</Text>
            <Text style={[styles.textNormal, {
                textAlign: 'left',
                marginTop: HEIGHTXD(20),
            }]}>{I18n.t('SmartOTPUsingForSecond')}</Text>
            <Text style={[styles.textNormal, {
                textAlign: 'left',
                marginTop: HEIGHTXD(20),
            }]}>{I18n.t('SmartOTPUsingForThird')}</Text>
        </View>
        <View style={{
            width: '100%',
            backgroundColor: R.colors.white,
            position: 'absolute',
            bottom: HEIGHTXD(0),
            justifyContent: 'center',
            paddingVertical: HEIGHTXD(30),
            paddingHorizontal: HEIGHTXD(30),
        }}>

            <Text style={styles.textSmall}>
                {I18n.t('OTPWillAutoFill')}
            </Text>
            <View
                style={{
                    paddingVertical: 10,
                    justifyContent: 'center',
                    alignItems: 'center',
                }}>
                <TouchableOpacity onPress={() => {
                    props.confirm();
                }} style={styles.btnSend}>
                    <Text style={styles.txtSend}>{I18n.t('ConfirmTransaction')}</Text>
                </TouchableOpacity>
            </View>
        </View>
    </View>;
};
const styles = StyleSheet.create({
    viewOTP: {
        width: getWidth() - HEIGHTXD(80),
        backgroundColor: R.colors.white,
        borderRadius: 8,
        justifyContent: 'center',
        alignItems: 'center',
        marginVertical: HEIGHTXD(40),
        marginHorizontal: HEIGHTXD(40),
        padding: WIDTHXD(40),
        borderColor: R.colors.gray1,
        borderWidth: 0.3,
    },
    btnSend: {
        width: '100%',
        height: HEIGHTXD(120),
        backgroundColor: R.colors.main,
        borderRadius: 8,
        justifyContent: 'center',
        alignItems: 'center',
    },
    txtSend: {
        fontSize: getFontXD(42),
        color: R.colors.white,
        paddingHorizontal: WIDTHXD(60),
        fontWeight: 'bold',
    },
    textSmall: {
        fontSize: getFontXD(32),
        color: R.colors.color777,
        marginBottom: 5,
        textAlign: 'center',
    },
    textNormal: {
        fontSize: getFontXD(39),
        color: R.colors.black,
        textAlign: 'center',
    },
    textOTP: {
        fontSize: getFontXD(100),
        color: R.colors.black,
        textAlign: 'center',
        marginVertical: HEIGHTXD(40),
    },
});
export default SmartOTPView;
