import React, {Component} from 'react';
import {View, Text, StyleSheet, Image, TouchableOpacity} from 'react-native';

import HeaderBack from '../../components/Header/HeaderBack';

import I18n from '../../helper/i18/i18n';
import AppText from '../../components/AppText';
import {
  UPDATEOTP,
  ENTER_PASSWORD_SMART_OTP,
  SETTINGOTP,
  FAQSSMARTOTP,
  RULESSMARTOTP,
} from '../../routers/ScreenNames';
import R from '../../assets/R';
import Icon from 'react-native-vector-icons/AntDesign';
import {HEIGHTXD, WIDTHXD} from '../../Config/Functions';
import {useNavigation} from '@react-navigation/native';
import {connect} from 'react-redux';

const SmartOTPConfig = (props) => {
  const navigation = useNavigation();

  console.log(props.user);
  return (
    <View style={{flex: 1}}>
      <HeaderBack title={'SettingOTP'} />
      <View style={{marginVertical: 20, backgroundColor: 'white'}}>
        {props.user.smart_otp_status ? (
          <TouchableOpacity
            onPress={() =>
              navigation.navigate(ENTER_PASSWORD_SMART_OTP, {
                type: 'CHANGE_SMART_OTP',
              })
            }
            style={styles.container}>
            <Image style={styles.imgIcon} source={R.images.changeSmart} />
            <View style={{flex: 1, justifyContent: 'center'}}>
              <AppText i18nKey={'ChangeSmartOTP'} />
            </View>
            <Icon name={'right'} size={20} color={R.colors.color777} />
          </TouchableOpacity>
        ) : null}

        <TouchableOpacity
          onPress={() => navigation.navigate(RULESSMARTOTP)}
          style={styles.container}>
          <Image style={styles.imgIcon} source={R.images.rules} />
          <View style={{flex: 1, justifyContent: 'center'}}>
            <AppText i18nKey={'Rules'} />
          </View>
          <Icon name={'right'} size={20} color={R.colors.color777} />
        </TouchableOpacity>
        <TouchableOpacity
          onPress={() => navigation.navigate(FAQSSMARTOTP)}
          style={styles.container}>
          <Image style={styles.imgIcon} source={R.images.faq} />
          <View style={{flex: 1, justifyContent: 'center'}}>
            <AppText i18nKey={'FAQs'} />
          </View>
          <Icon name={'right'} size={20} color={R.colors.color777} />
        </TouchableOpacity>
      </View>
    </View>
  );
};

const styles = StyleSheet.create({
  container: {
    flexDirection: 'row',
    alignItems: 'center',
    justifyContent: 'space-between',
    paddingHorizontal: 10,
    paddingVertical: 10,
    borderBottomColor: R.colors.borderGray,
    borderBottomWidth: 0.6,
  },
  imgIcon: {
    width: WIDTHXD(62),
    height: WIDTHXD(62),
    resizeMode: 'contain',
    marginRight: 10,
  },
});

const mapStateToProps = (state) => {
  return {
    user: state.userReducer,
  };
};

export default connect(mapStateToProps, {})(SmartOTPConfig);
