import React, {useState, useEffect} from 'react';
import SmartOTPView from './SmartOTPView';
import {showAlert, TYPE} from '../../components/DropdownAlert';
import I18n from '../../helper/i18/i18n';
import {getOTPApiSmartOTP, verifyOTPApi} from '../../apis/Functions/users';
import {Platform} from 'react-native';
import {walletDeposit} from '../../apis/Functions/Deposit';
import {widthDraw} from '../../apis/Functions/Widthdraw';
import {TABNAVIGATOR} from '../../routers/ScreenNames';
import {connect} from 'react-redux';
import {hideLoading, showLoading} from '../../actions/loadingAction';
import {OTP_TYPE} from '../../Config/constants';
import {useNavigation} from '@react-navigation/native';
import {encryptRSAString, decryptRSAString} from '../../Config/Functions';

const SmartOTP = (props) => {
  const [value, setValue] = useState(props.route.params.otp);
  const [progress, setProgress] = useState(1);
  const [isReset, setReset] = useState(false);
  const navigate = useNavigation();
  useEffect(() => {
    setValue(props.route.params.otp);
  }, [props.route.params.otp]);
  const confirm = async () => {
    if (!value) {
      showAlert(TYPE.WARN, I18n.t('Notification'), I18n.t('EnterOTPRequest'));
    } else if (value.length != 4) {
      showAlert(TYPE.WARN, I18n.t('Notification'), I18n.t('OTPInvalid'));
    } else {
      props.showLoading();
      let res1 = await verifyOTPApi({
        platform: Platform.OS,
        receiver_name: props.user.email,
        otp: encryptRSAString(value),
        type:
          props.route.params.type == 'DEPOSIT'
            ? OTP_TYPE.CUSTOMER_REQUEST_DEPOSIT
            : OTP_TYPE.REQUEST_WITHDRAW,
      });

      if (res1.data.code == 200) {
        let res;
        if (props.route.params.type == 'DEPOSIT') {
          const {amount, notes} = props.route.params;

          res = await walletDeposit({
            amount,
            platform: Platform.OS,
            notes,
            fee: 0,
            otp: encryptRSAString(value),
          });
        } else {
          const {src, receiving_account, amount, notes} = props.route.params;
          res = await widthDraw({
            src,
            receiving_account,
            amount,
            platform: Platform.OS,
            notes,
            fee: 0,
            otp: encryptRSAString(value),
          });
        }

        props.hideLoading();
        if (res.data.code == 200) {
          setTimeout(() => {
            showAlert(TYPE.SUCCESS, I18n.t('Notification'), res.data.message);

            navigate.navigate(TABNAVIGATOR);
          }, 500);
        } else {
          showAlert(TYPE.ERROR, I18n.t('Notification'), res.data.message);
        }
      } else {
        showAlert(TYPE.ERROR, I18n.t('Notification'), res1.data.message);
      }

      props.hideLoading();
    }
  };
  const getNewOTP = async () => {
    props.showLoading();
    const res = await getOTPApiSmartOTP({
      platform: Platform.OS,
      otp_by: props.user.email,
      otp_password: encryptRSAString(props.route.params.pinCode),
      type:
        props.route.params.type == 'DEPOSIT'
          ? OTP_TYPE.CUSTOMER_REQUEST_DEPOSIT
          : OTP_TYPE.REQUEST_WITHDRAW,
    });
    if (res.data.code == 200) {
      setValue(decryptRSAString(res.data.data.otp));
      setReset(!isReset);
    } else {
      showAlert(TYPE.ERROR, I18n.t('Notification'), res.data.message);
    }
    props.hideLoading();
  };

  const updateProgress = (count) => {
    setProgress(count > 0 ? count / 300 : 0);
  };

  return (
    <SmartOTPView
      value={value}
      progress={progress}
      confirm={confirm}
      isReset={isReset}
      getNewOTP={getNewOTP}
      updateProgress={updateProgress}
      setValue={setValue}
    />
  );
};
const mapStateToProps = (state) => {
  return {
    user: state.userReducer,
  };
};

export default connect(mapStateToProps, {showLoading, hideLoading})(SmartOTP);
