import React, {Component, useState} from 'react';
import {View, Text} from 'react-native';
import {CONFIRMOTPSMART} from '../../routers/ScreenNames';
import {useNavigation} from '@react-navigation/native';
import HeaderBack from '../../components/Header/HeaderBack';

import AppText from '../../components/AppText';
import TextField from '../../components/Input/TextField';
import Button from '../../components/Button';
import {connect} from 'react-redux';
import {
  getFontXD,
  HEIGHTXD,
  WIDTHXD,
  checkFormatArray,
} from '../../Config/Functions';
import R from '../../assets/R';
import {getOTPApiSmartOTP} from '../../apis/Functions/users';
import {showLoading, hideLoading} from '../../actions/loadingAction';
import I18n from '../../helper/i18/i18n';
import {TYPE, showAlert} from '../../components/DropdownAlert/index';

const SettingOTP = (props) => {
  const navigatiton = useNavigation();

  const [password, setPassword] = useState('');
  const [password_confirmation, setPassword_confirmation] = useState('');

  const getOTP = async () => {
    const titles = [
      I18n.t('PassGetSmartOTP'),
      I18n.t('ConfirmPassGetSmartOTP'),
    ];
    const index = checkFormatArray([password, password_confirmation]);
    if (index === true) {
      if (password == password_confirmation) {
        props.showLoading();
        const res = await getOTPApiSmartOTP({
          platform: Platform.OS,
          otp_by: props.user.email,
          otp_password: '1234',
          type: 'CREATE_OTP_PASSWORD',
        });
        props.hideLoading();
        if (res.data.code == 200) {
          showAlert(TYPE.SUCCESS, I18n.t('Notification'), res.data.message);
          navigatiton.navigate(CONFIRMOTPSMART, {
            password,
            password_confirmation,
            isFromTransaction: props.route.params.isFromTransaction,
            setupSmartOTPSuccess: props.route.params.setupSmartOTPSuccess
          });
        } else {
          showAlert(TYPE.ERROR, I18n.t('Notification'), res.data.message);
        }
      } else {
        showAlert(
          TYPE.WARN,
          I18n.t('Notification'),
          'Mật khẩu không trùng nhau!',
        );
      }
    } else {
      showAlert(
        TYPE.WARN,
        I18n.t('Notification'),
        I18n.t('Please_fill_in') + titles[index],
      );
    }
  };

  return (
    <View style={{flex: 1}}>
      <HeaderBack title={'SettingOTP'} />
      <View style={{flex: 1, marginHorizontal: 10, marginTop: 20}}>
        <View style={{flex: 1}}>
          <TextField
            onChangeText={(val) => setPassword(val)}
            maxLength={4}
            isNumber={true}
            title={
              props.language.language == 'vi'
                ? 'Mật khẩu lấy Smart OTP'
                : I18n.t('PassGetSmartOTP')
            }
            isPassWord={true}
          />
          <TextField
            maxLength={4}
            isNumber={true}
            isPassWord={true}
            onChangeText={(val) => setPassword_confirmation(val)}
            title={
              props.language.language == 'vi'
                ? 'Xác nhận mật khẩu lấy Smart OTP'
                : I18n.t('ConfirmPassGetSmartOTP')
            }
          />
        </View>
        <View>
          <Button onClick={getOTP} title={'Xác nhận'} />
        </View>
      </View>
    </View>
  );
};

const mapStateToProps = (state) => {
  return {
    user: state.userReducer,
    language: state.languageReducer,
  };
};

export default connect(mapStateToProps, {showLoading, hideLoading})(SettingOTP);
