import React, {useEffect, useState} from 'react';
import {Linking, StyleSheet, Text, TouchableOpacity, View} from 'react-native';
import HeaderBack from '../../components/Header/HeaderBack';
import AppText from '../../components/AppText';
import {getFontXD, HEIGHTXD, WIDTHXD, callNumber} from '../../Config/Functions';
import R from '../../assets/R';
import I18n from '../../helper/i18/i18n';


const ResetSmartOTPView = (props) => {
    const [reRender, setReRender] = useState(false);
    useEffect(() => {
        setReRender(!reRender);
    }, [props.companyInfo]);
    return <View style={{flex: 1}}>
        <HeaderBack title={props.title}/>
        <View
            style={{
                flex: 1,
                paddingHorizontal: WIDTHXD(50),
                paddingTop: HEIGHTXD(40),
            }}>
            <Text>
                <AppText i18nKey={'ResetSmartOTP'} style={styles.title}/>
                <Text style={[styles.txtContent, {color: R.colors.main}]}
                      onPress={() => callNumber(props.companyInfo?.hotline_call)}>
                    {props.companyInfo?.hotline}
                </Text>
                <AppText i18nKey={'ResetSmartOTP2'} style={styles.title}/>
            </Text>

            <AppText i18nKey={'HaNoiOffice'} style={[styles.title, {color: R.colors.main, marginTop: HEIGHTXD(30)}]}/>
            <Text style={styles.txtContent}>{props.companyInfo?.name}</Text>

            <Text style={styles.txtContent}>{`${I18n.t('Address')} ${props.companyInfo?.address}`}</Text>

            <View style={styles.row}>
                <Text style={styles.title}>Email:</Text>
                <TouchableOpacity
                    onPress={async () => {
                        const supported = await Linking.openURL(`mailto:${props.companyInfo?.email}`);
                        if (supported) {
                            Linking.openURL(`mailto:${props.companyInfo?.email}`);
                        }
                    }}>
                    <Text style={styles.txtLink}> {props.companyInfo?.email}</Text>
                </TouchableOpacity>
            </View>
            <TouchableOpacity
                onPress={async () => {
                    const supported = await Linking.canOpenURL(props.companyInfo?.website);
                    if (supported) {
                        Linking.openURL(props.companyInfo?.website);
                    }
                }}>
                <View style={styles.row}>
                    <Text style={styles.title}>Website: </Text>
                    <Text style={styles.txtLink}>{props.companyInfo?.website}</Text>
                </View>
            </TouchableOpacity>

        </View>
    </View>;

};
const styles = StyleSheet.create({
    title: {
        fontSize: getFontXD(42),
        color: R.colors.black,
        marginTop: 5,
    },
    txtContent: {
        fontSize: getFontXD(42),
        marginTop: 5,
    },
    txtLink: {
        fontSize: getFontXD(42),
        marginTop: 5,
        textDecorationLine: 'underline',
        color: R.colors.main,
    },
    row: {
        flexDirection: 'row',
    },
});
export default ResetSmartOTPView;
