import React, {useState, useEffect} from 'react';
import EnterPasswordSmartOTPView from './EnterPasswordSmartOTPView';
import {getOTPApiSmartOTP, verifyOTPApiSmart} from '../../apis/Functions/users';
import {showAlert, TYPE} from '../../components/DropdownAlert';
import I18n from '../../helper/i18/i18n';
import {connect} from 'react-redux';
import {hideLoading, showLoading} from '../../actions/loadingAction';
import {OTP_TYPE} from '../../Config/constants';
import {useNavigation} from '@react-navigation/native';
import {RESET_SMART_OTP, CHANGESMARTOTP} from '../../routers/ScreenNames';
import {decryptRSAString, encryptRSAString} from '../../Config/Functions';

const EnterPasswordSmartOTP = (props) => {
  const navigation = useNavigation();
  const [firstNumber, setFirstNumber] = useState(null);
  const [secondsNumber, setSecondsNumber] = useState(null);
  const [thirdNumber, setThirdNumber] = useState(null);
  const [fourNumber, setFourNumber] = useState(null);
  useEffect(() => {
    if (fourNumber) {
      onCheckPINSmartOTPPin();
    }
  }, [fourNumber]);
  const onNumberPress = (number) => {
    if (!firstNumber) {
      setFirstNumber(number.toString());
    } else if (!secondsNumber) {
      setSecondsNumber(number.toString());
    } else if (!thirdNumber) {
      setThirdNumber(number.toString());
    } else if (!fourNumber) {
      setFourNumber(number.toString());
    }
  };

  const onCheckPINSmartOTPPin = async () => {
    let pinCode = `${firstNumber}${secondsNumber}${thirdNumber}${fourNumber}`;
    props.showLoading();
    if (props.route.params.type == 'CHANGE_SMART_OTP') {
      const res = await verifyOTPApiSmart({
        platform: Platform.OS,
        otp_password: encryptRSAString(pinCode),
        type: 'VERIFY_OTP_PASSWORD',
      });
      if (res.data.code == 200) {
        navigation.navigate(CHANGESMARTOTP, {
          old_password: encryptRSAString(pinCode),
          TYPE: 'CHANGE_SMART_OTP',
        });
        clearPIN();
      } else {
        showAlert(TYPE.ERROR, I18n.t('Notification'), res.data.message);
        clearPIN();
      }
    } else {
      props.showLoading();
      const res = await getOTPApiSmartOTP({
        platform: Platform.OS,
        otp_by: props.user.email,
        otp_password: encryptRSAString(pinCode),
        type:
          props.route.params.type == 'DEPOSIT'
            ? OTP_TYPE.CUSTOMER_REQUEST_DEPOSIT
            : OTP_TYPE.REQUEST_WITHDRAW,
      });
      props.hideLoading();

      if (res.data.code == 200) {
        props.route.params.onGoToSmartOTP(
          pinCode,
          decryptRSAString(res.data.data.otp),
        );
      } else {
        showAlert(TYPE.ERROR, I18n.t('Notification'), res.data.message);
        clearPIN();
      }
    }
    props.hideLoading();
  };
  const clearPIN = () => {
    setFirstNumber(null);
    setSecondsNumber(null);
    setThirdNumber(null);
    setFourNumber(null);
  };
  const onDeletePress = () => {
    if (fourNumber) {
      setFourNumber(null);
    } else if (thirdNumber) {
      setThirdNumber(null);
    } else if (secondsNumber) {
      setSecondsNumber(null);
    } else if (firstNumber) {
      setFirstNumber(null);
    }
  };
  const onReactivationSmartOTP = () => {
    navigation.navigate(RESET_SMART_OTP, {title: 'ReactivationSmartOTP'});
  };

  const onForgotPINCode = () => {
    navigation.navigate(RESET_SMART_OTP, {title: 'ForgotSmartOTP'});
  };
  return (
    <EnterPasswordSmartOTPView
      firstNumber={firstNumber}
      secondsNumber={secondsNumber}
      thirdNumber={thirdNumber}
      fourNumber={fourNumber}
      onNumberPress={onNumberPress}
      onDeletePress={onDeletePress}
      onForgotPINCode={onForgotPINCode}
      onReactivationSmartOTP={onReactivationSmartOTP}
    />
  );
};
const mapStateToProps = (state) => {
  return {
    user: state.userReducer,
  };
};

export default connect(mapStateToProps, {showLoading, hideLoading})(
  EnterPasswordSmartOTP,
);
