import React from 'react';
import {StyleSheet, Text, TouchableOpacity, View} from 'react-native';
import HeaderBack from '../../../components/Header/HeaderBack';
import {getFontXD, HEIGHTXD, WIDTHXD} from '../../../Config/Functions';
import I18n from '../../../helper/i18/i18n';
import R from '../../../assets/R';
import Icon from 'react-native-vector-icons/FontAwesome5';

const ChangeSmartOTPView = (props) => {
  return (
    <View style={{flex: 1, colorBackground: R.colors.white}}>
      <HeaderBack title={'OTP'} />
      <Text style={[styles.textNormal, {marginTop: HEIGHTXD(40)}]}>
        {I18n.t('EnterOTPRequest')}
      </Text>
      <View style={[styles.rowNumber]}>
        <View
          style={[
            styles.indicator,
            {
              backgroundColor: props.firstNumber
                ? R.colors.main
                : R.colors.white,
            },
          ]}
        />
        <View
          style={[
            styles.indicator,
            {
              backgroundColor: props.secondsNumber
                ? R.colors.main
                : R.colors.white,
            },
          ]}
        />
        <View
          style={[
            styles.indicator,
            {
              backgroundColor: props.thirdNumber
                ? R.colors.main
                : R.colors.white,
            },
          ]}
        />
        <View
          style={[
            styles.indicator,
            {
              backgroundColor: props.fourNumber
                ? R.colors.main
                : R.colors.white,
            },
          ]}
        />
      </View>
      <View style={[styles.rowNumber, {marginTop: HEIGHTXD(80)}]}>
        <TouchableOpacity
          onPress={() => {
            props.onNumberPress(1);
          }}
          style={styles.btnNumber}>
          <Text style={styles.textNumber}>1</Text>
        </TouchableOpacity>
        <TouchableOpacity
          onPress={() => {
            props.onNumberPress(2);
          }}
          style={[styles.btnNumber, {marginLeft: WIDTHXD(40)}]}>
          <Text style={styles.textNumber}>2</Text>
        </TouchableOpacity>
        <TouchableOpacity
          onPress={() => {
            props.onNumberPress(3);
          }}
          style={[styles.btnNumber, {marginLeft: WIDTHXD(40)}]}>
          <Text style={styles.textNumber}>3</Text>
        </TouchableOpacity>
      </View>
      <View style={styles.rowNumber}>
        <TouchableOpacity
          onPress={() => {
            props.onNumberPress(4);
          }}
          style={styles.btnNumber}>
          <Text style={styles.textNumber}>4</Text>
        </TouchableOpacity>
        <TouchableOpacity
          onPress={() => {
            props.onNumberPress(5);
          }}
          style={[styles.btnNumber, {marginLeft: WIDTHXD(40)}]}>
          <Text style={styles.textNumber}>5</Text>
        </TouchableOpacity>
        <TouchableOpacity
          onPress={() => {
            props.onNumberPress(6);
          }}
          style={[styles.btnNumber, {marginLeft: WIDTHXD(40)}]}>
          <Text style={styles.textNumber}>6</Text>
        </TouchableOpacity>
      </View>
      <View style={styles.rowNumber}>
        <TouchableOpacity
          onPress={() => {
            props.onNumberPress(7);
          }}
          style={styles.btnNumber}>
          <Text style={styles.textNumber}>7</Text>
        </TouchableOpacity>
        <TouchableOpacity
          onPress={() => {
            props.onNumberPress(8);
          }}
          style={[styles.btnNumber, {marginLeft: WIDTHXD(40)}]}>
          <Text style={styles.textNumber}>8</Text>
        </TouchableOpacity>
        <TouchableOpacity
          onPress={() => {
            props.onNumberPress(9);
          }}
          style={[styles.btnNumber, {marginLeft: WIDTHXD(40)}]}>
          <Text style={styles.textNumber}>9</Text>
        </TouchableOpacity>
      </View>
      <View style={styles.rowNumber}>
        <TouchableOpacity
          onPress={() => {
            props.onNumberPress(0);
          }}
          style={[styles.btnNumber, {marginLeft: WIDTHXD(300)}]}>
          <Text style={styles.textNumber}>0</Text>
        </TouchableOpacity>
        <TouchableOpacity
          onPress={() => {
            props.onDeletePress();
          }}
          style={{
            width: HEIGHTXD(260),
            height: HEIGHTXD(260),
            marginLeft: WIDTHXD(40),
            justifyContent: 'center',
            alignItems: 'center',
          }}>
          <Icon name={'backspace'} size={HEIGHTXD(80)} color={'#8E8C8C'} />
        </TouchableOpacity>
      </View>
    </View>
  );
};
export default ChangeSmartOTPView;
const styles = StyleSheet.create({
  btnSend: {
    height: HEIGHTXD(80),
    justifyContent: 'center',
    alignItems: 'center',
  },

  rowNumber: {
    flexDirection: 'row',
    justifyContent: 'center',
    marginTop: HEIGHTXD(40),
  },

  btnNumber: {
    height: HEIGHTXD(260),
    width: HEIGHTXD(260),
    justifyContent: 'center',
    alignItems: 'center',
    borderWidth: 0.3,
    borderColor: R.colors.gray6,
    borderRadius: HEIGHTXD(130),
  },

  indicator: {
    height: HEIGHTXD(50),
    width: HEIGHTXD(50),
    borderWidth: 0.3,
    borderColor: R.colors.gray6,
    borderRadius: HEIGHTXD(35),
    marginHorizontal: WIDTHXD(20),
  },

  textNormal: {
    fontSize: getFontXD(39),
    color: R.colors.black,
    textAlign: 'center',
  },

  textNumber: {
    fontSize: getFontXD(90),
    color: R.colors.black,
    textAlign: 'center',
  },
  txtSend: {
    fontSize: getFontXD(42),
    color: R.colors.main,
  },
});
