import React, {useState, useEffect} from 'react';
import ConfirmSmartOTPView from './ConfirmSmartOTPView';
import {
  updateOTPApiSmart,
  getOTPApiSmartOTP,
} from '../../../apis/Functions/users';
import {showAlert, TYPE} from '../../../components/DropdownAlert';
import {connect} from 'react-redux';
import {hideLoading, showLoading} from '../../../actions/loadingAction';
import I18n from '../../../helper/i18/i18n';
import {
  SMARTOTPCONFIG,
  TABNAVIGATOR,
  CONFIRMCREATEOTP,
} from '../../../routers/ScreenNames';
import {useNavigation} from '@react-navigation/native';
import {encryptRSAString} from '../../../Config/Functions';

const ConfirmChangeSmartOTP = (props) => {
  const [firstNumber, setFirstNumber] = useState(null);
  const [secondsNumber, setSecondsNumber] = useState(null);
  const [thirdNumber, setThirdNumber] = useState(null);
  const [fourNumber, setFourNumber] = useState(null);
  const navigation = useNavigation();
  useEffect(() => {
    if (fourNumber) {
      onCheckPINSmartOTPPin();
    }
  }, [fourNumber]);
  const onNumberPress = (number) => {
    if (!firstNumber) {
      setFirstNumber(number.toString());
    } else if (!secondsNumber) {
      setSecondsNumber(number.toString());
    } else if (!thirdNumber) {
      setThirdNumber(number.toString());
    } else if (!fourNumber) {
      setFourNumber(number.toString());
    }
  };

  console.log('Pros pass', props.route.params);

  const onCheckPINSmartOTPPin = async () => {
    let pinCode = `${firstNumber}${secondsNumber}${thirdNumber}${fourNumber}`;

    if (props.route.params.TYPE == 'CHANGE_SMART_OTP') {
      props.showLoading();
      const res = await updateOTPApiSmart({
        platform: Platform.OS,
        password: encryptRSAString(props.route.params.pre_otp),
        password_confirmation: encryptRSAString(pinCode),
        old_password: encryptRSAString(props.route.params.old_password),
      });
      props.hideLoading();
      if (res.data.code == 200) {
        showAlert(TYPE.SUCCESS, I18n.t('Notification'), res.data.message);
        setFirstNumber(null);
        setSecondsNumber(null);
        setThirdNumber(null);
        setFourNumber(null);
        navigation.navigate(SMARTOTPCONFIG);
      } else {
        showAlert(TYPE.ERROR, I18n.t('Notification'), res.data.message);
        setFirstNumber(null);
        setSecondsNumber(null);
        setThirdNumber(null);
        setFourNumber(null);
      }
    } else {
      props.showLoading();
      const res = await getOTPApiSmartOTP({
        platform: Platform.OS,
        otp_by: props.user.email,
        otp_password: '1234',
        type: 'CREATE_OTP_PASSWORD',
      });

      props.hideLoading();

      if (res.data.code == 200) {
        showAlert(TYPE.SUCCESS, I18n.t('Notification'), res.data.message);

        if (props.route.params.isFromTransaction) {
          navigation.navigate(CONFIRMCREATEOTP, {
            password: props.route.params.pre_otp,
            password_confirmation: pinCode,
            isFromTransaction: props.route.params.isFromTransaction,
            setupSmartOTPSuccess: props.route.params.setupSmartOTPSuccess,
          });
        } else {
          navigation.navigate(CONFIRMCREATEOTP, {
            password: props.route.params.pre_otp,
            password_confirmation: pinCode,
          });
        }
      } else {
        showAlert(TYPE.ERROR, I18n.t('Notification'), res.data.message);
      }
    }
  };
  const onDeletePress = () => {
    if (fourNumber) {
      setFourNumber(null);
    } else if (thirdNumber) {
      setThirdNumber(null);
    } else if (secondsNumber) {
      setSecondsNumber(null);
    } else if (firstNumber) {
      setFirstNumber(null);
    }
  };

  return (
    <ConfirmSmartOTPView
      firstNumber={firstNumber}
      secondsNumber={secondsNumber}
      thirdNumber={thirdNumber}
      fourNumber={fourNumber}
      onNumberPress={onNumberPress}
      onDeletePress={onDeletePress}
    />
  );
};
const mapStateToProps = (state) => {
  return {
    user: state.userReducer,
  };
};

export default connect(mapStateToProps, {showLoading, hideLoading})(
  ConfirmChangeSmartOTP,
);
